/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.topology.InternalEndpointG;
import org.petalslink.easiestdemo.client.topology.menu.action.NodeListModel;

public class MoveEndpointToNodeFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private WSOUIClient client;
    private Registry registry;
    private InternalEndpointG endpointToMove;
    private Node selectedNode = null;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAddConnexion;
    private JLabel jLabelMoveEndpoint;
    private JLabel jLabelMoveEndpointOnNode;
    private JLabel jLabelMoveEndpointValue;
    private JLabel jLabelToNode;
    private JLabel jLabelToNodeValue;
    private JList jListNodes;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneListNodes;

    public MoveEndpointToNodeFrame(WSOUIClient client, InternalEndpointG endpointToMove) {
        this.initComponents();
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.jCheckBoxAddConnexion.setOpaque(false);
        this.client = client;
        this.registry = client.getRegistry();
        this.endpointToMove = endpointToMove;
        this.setTitle("Move endpoint " + this.endpointToMove.getQName().getLocalPart() + " on node");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.jLabelMoveEndpointValue.setText(this.endpointToMove.getQName().getLocalPart());
        this.jCheckBoxAddConnexion.setSelected(true);
        this.jListNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelMoveEndpointOnNode = new JLabel();
        this.jScrollPaneListNodes = new JScrollPane();
        this.jListNodes = new JList();
        this.jCheckBoxAddConnexion = new JCheckBox();
        this.jButtonOK = new JButton();
        this.jLabelMoveEndpoint = new JLabel();
        this.jLabelMoveEndpointValue = new JLabel();
        this.jLabelToNode = new JLabel();
        this.jLabelToNodeValue = new JLabel();
        this.jLabelMoveEndpointOnNode.setText("Move endpoint on node:");
        this.jListNodes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListNodes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MoveEndpointToNodeFrame.this.jListNodesMouseClicked(evt);
            }
        });
        this.jScrollPaneListNodes.setViewportView(this.jListNodes);
        this.jCheckBoxAddConnexion.setText("Add connexion between nodes if not exist?");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveEndpointToNodeFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelMoveEndpoint.setText("Move endpoint:");
        this.jLabelToNode.setText("to node:");
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jScrollPaneListNodes, -2, 161, -2).addGap(34, 34, 34).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMoveEndpoint).addComponent(this.jCheckBoxAddConnexion).addGroup(jPanelMainLayout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMoveEndpointValue, -1, 353, Short.MAX_VALUE).addGroup(jPanelMainLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelToNode).addGroup(jPanelMainLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelToNodeValue, -2, 333, -2).addComponent(this.jButtonOK))))))))).addComponent(this.jLabelMoveEndpointOnNode)).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 346, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanelMainLayout.createSequentialGroup().addGap(77, 77, 77).addComponent(this.jLabelMoveEndpoint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMoveEndpointValue, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelToNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelToNodeValue, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAddConnexion).addGap(78, 78, 78).addComponent(this.jButtonOK)).addGroup(GroupLayout.Alignment.LEADING, jPanelMainLayout.createSequentialGroup().addComponent(this.jLabelMoveEndpointOnNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneListNodes, -2, 304, -2))).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 346, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelMain, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.registry.moveEndpointToNode(this.endpointToMove.getModel(), this.selectedNode, this.jCheckBoxAddConnexion.isSelected());
            this.setVisible(false);
            this.client.getTopology().repaint();
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "MoveEndpointToNode Interrupted", 0);
        }
    }

    private void jListNodesMouseClicked(MouseEvent evt) {
        this.selectedNode = (Node)this.jListNodes.getSelectedValue();
        this.jLabelToNodeValue.setText(this.selectedNode.getQName().getLocalPart());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MoveEndpointToNodeFrame(null, null).setVisible(true);
            }
        });
    }
}

