/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.model.impl.ws;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MockBindingImpl implements MockBinding {

	private MockEndpoint endpoint;
	private Binding binding;

	private List<MockOperation> operations = new ArrayList<MockOperation>();

	public MockBindingImpl(MockEndpoint ep, Binding binding) throws SOAPException {
		this.endpoint = ep;
		this.binding = binding;
		
		for(BindingOperation bop: binding.getOperations()) {
			this.operations.add(new MockOperationImpl(this, bop));
		}
	}

	@Override
	public MockEndpoint getEndpoint() {
		return this.endpoint;
	}


	@Override
	public QName getQName() {
		return this.binding.getQName();
	}




	@Override
	public List<MockOperation> getOperations() {
		return this.operations;
	}


	@Override
	public QName getInterfaceQName() {
		return this.binding.getInterface().getQName();
	}


	public String toString() {
		return this.getQName().toString();
	}



}
