package org.petalslink.easiestdemo.client.model.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Endpoint;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.esb.NodeImpl;
import org.petalslink.easiestdemo.client.model.impl.gov.GovNodeImpl;
import org.petalslink.easiestdemo.client.model.impl.ws.MockServiceImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.datacollector.DataCollectorComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.Constants;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.initialization.RawReportIntializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.core.container.Container;

import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbPropertyType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.ObjectFactory;
import esstar.petalslink.com.service.management._1_0.ManagementException;

public class RegistryImpl implements Registry {

	static {
		try {
			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}
	}

	ESBFactory esbFactory = BusManagement.getInstance().getESBFactory();

	ESBFactory bsmFactory = BusManagement.getInstance().getMonitoringFactory();

	protected List<Node> nodes = new ArrayList<Node>();

	protected List<MockService> webServices = new ArrayList<MockService>();

	protected GovNode govNode = null;

	private SOAPSender sender = new SOAPSender();

	public RegistryImpl() throws SOAPException {
	}

	@Override
	public List<Node> getAllNodes() {
		return this.nodes;
	}

	@Override
	public List<MockService> getWebServices() {
		return this.webServices;
	}

	@Override
	public void importGovernance(String adminManagerAddress) throws SOAPException {
		this.govNode = new GovNodeImpl(adminManagerAddress, this);
	}

	@Override
	public void addNewWsdlofWebServices(URL... urls) throws WSOUIClientException {
		try {
			if(urls != null) {
				for(URL url: urls) {
					// read WSDL 1.1 definitions from url
					try {
						Definitions definitions = SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(url, Definitions.class);
						Description desc = (Description) Factory.getInstance().wrap(definitions);
						if(!this.existInDescriptionList(this.getDescriptionsOfWebServices(), desc)) {
							this.addDescriptionOfWebServices(desc);
						}
					} catch (XmlObjectReadException e) {
						throw new WSOUIClientException(e);
					}
				}
			}
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		}
	}

	@Override
	public void addDescriptionOfWebServices(Description... descs) throws SOAPException {
		if(descs != null) {
			for(Description desc: descs) {
				for(Service s: desc.getServices()) {
					this.webServices.add(new MockServiceImpl(s));
				}
			}
		}
	}

	@Override
	public Node addNewAdminWsdlofESBNode(URL... urls) throws WSOUIClientException {
		Node n = null;
		try {
			if(urls != null) {
				for(URL url: urls) {
					// read WSDL 1.1 definitions from url
					try {
						Definitions definitions = SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(url, Definitions.class);
						Description desc = (Description) Factory.getInstance().wrap(definitions);
						if(!this.existInDescriptionList(this.getDescriptionsOfAdminESBNodes(), desc)) {
							n = this.addDescriptionOfAdminEsbNode(desc);
						}
					} catch (XmlObjectReadException e) {
						throw new WSOUIClientException(e);
					}
				}
			}
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		}
		return n;
	}

	@Override
	public Node addDescriptionOfAdminEsbNode(Description... descs)
			throws SOAPException {
		Node n = null;
		if(descs != null) {
			for(Description desc: descs) {
				n = new NodeImpl(desc, this);
				this.nodes.add(n);

				for(ProviderEndpointProxy pep: n.getProviderEndpointProxies()) {
					this.addDescriptionOfWebServices(pep.getDescription());
				}
			}
		}
		return n;
	}

	@Override
	public List<Description> getDescriptionsOfWebServices() {
		List<Description> descs = new ArrayList<Description>();
		for(MockService s: this.webServices) {
			descs.add(s.getDescription());
		}
		return descs;
	}

	@Override
	public List<Description> getDescriptionsOfAdminESBNodes() {
		List<Description> descs = new ArrayList<Description>();
		for(Node n: this.nodes) {
			descs.add(n.getAdministrationServiceDescription());
		}
		return descs;
	}

	@Override
	public List<ClientEndpointProxy> getAllClientEndpointProxy() {
		List<ClientEndpointProxy> res = new ArrayList<ClientEndpointProxy>();
		for(Node n: this.nodes) {
			if(n != null) {
				res.addAll(n.getClientEndpointProxies());
			}
		}
		return res;
	}

	@Override
	public List<MockEndpoint> getAllWebServicesPartnerEndpoint() {
		List<MockEndpoint> res = new ArrayList<MockEndpoint>();
		for(MockService s: this.webServices) {
			res.addAll(s.getEndpoints());
		}
		return res;
	}

	private boolean existInDescriptionList(List<Description> descriptions,
			Description desc) {
		boolean res = false;

		for(Description d: descriptions) {
			if(d.getDocumentBaseURI().toString().equals(desc.getDocumentBaseURI().toString())) {
				res = true;
				break;
			}
		}
		return res;
	}

	@Override
	public Node findNodeByAdminUrl(URL adminUrl) throws WSOUIClientException {
		Node res = null;
		try {
			for(Node n: this.nodes) {
				URI baseUri = n.getAdministrationServiceDescription().getDocumentBaseURI();
				if(baseUri.toString().equals(adminUrl.toURI().toString())) {
					res = n;
					break;
				}
			}
		} catch (URISyntaxException e) {
			throw new WSOUIClientException(e);
		}
		return res;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void createNode(String nodeName, String nodeNameSpace, String host, String port, final String soapPort, boolean monitoring) throws WSOUIClientException {
		try {
			com.ebmwebsourcing.easyesb.soa.api.node.Node node = null;
			String admin = null;
			if(!monitoring) {
				Configuration conf = new ConfigurationImpl(host, Integer.parseInt(port), new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, soapPort);}});
				node = esbFactory.createNode(new QName(nodeNameSpace, nodeName), conf);
				admin = "http://" + host + ":" + soapPort + "/services/adminExternalEndpoint";
			} else {
				Configuration conf = new ConfigurationImpl(host, Integer.parseInt(port), new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, soapPort);}});
				node = bsmFactory.createNode(new QName(nodeNameSpace, nodeName), conf);
				admin = "http://" + host + ":" + soapPort + "/services/bsmadminExternalEndpoint";
			}
			URL adminUrl = new URL(admin + "?wsdl");
			this.addNewAdminWsdlofESBNode(adminUrl);		
			Node n = findNodeByAdminUrl(adminUrl);
			n.setModel(node);
			n.setBasicInfos((EJaxbBasicNodeInformationsType) ((NodeType)node.getModel()).getBasicNodeInformations().getModelObject());
			if(monitoring) {
				n.setMonitoringNode(true);
			}
		} catch (NumberFormatException e) {
			throw new WSOUIClientException(e);
		} catch (ESBException e) {
			throw new WSOUIClientException(e);
		} catch (MalformedURLException e) {
			throw new WSOUIClientException(e);
		} catch (WSOUIClientException e) {
			throw new WSOUIClientException(e);
		}
	}

	@Override
	public void addNeighBourNode(Node source, Node target) throws WSOUIClientException {
		try {
			AddNeighBourNode request = new AddNeighBourNode();
			request.setNeighbourNode(target.getBasicInfos());

			easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse response = source.getAdminClient().addNeighBourNode(request);

			source.getNeighbourNodeNames().add(target.getQName());
		} catch (ManagementException e) {
			throw new WSOUIClientException(e);
		} 
	}

	@Override
	public void deployBpel(Node source, URL bpel) throws WSOUIClientException {
		try {

			EJaxbDeployementReport response = source.getAdminClient().deploy(bpel);

			this.getStateOfNode(source);
		} catch (ManagementException e) {
			throw new WSOUIClientException(e);
		} catch (WSOUIClientException e) {
			throw new WSOUIClientException(e);
		}
	}

	@Override
	public void moveEndpointToNode(Endpoint endpoint, Node targetNode, boolean addConnection) throws WSOUIClientException {
		try {
			if(endpoint == null && targetNode == null) {
				throw new ESBException("endpoint or target cannot be null");
			}
			Node sourceNode = endpoint.getNode();
			URI endpointReference = null;
			if(endpoint instanceof ProviderEndpointProxy) {
				endpointReference = ESBUtil.generateURI(new EndpointAddress(((ProviderEndpointProxy)endpoint).getService().getQName(), ((ProviderEndpointProxy)endpoint).getEndpoint().getName()));
			} else if(endpoint instanceof ClientEndpointProxy) {
				endpointReference = ESBUtil.generateURI(new EndpointAddress(((ClientEndpointProxy)endpoint).getName().getNamespaceURI(), null, ((ClientEndpointProxy)endpoint).getName().getLocalPart()));
			}

			if(sourceNode.getQName().equals(targetNode.getQName())) {
				throw new ESBException("target node must be different of source node");
			}

			// move to node
			MoveEnpointToNode payload = new MoveEnpointToNode();
			payload.setEndpointReference(endpointReference.toString());
			payload.setBasicNodeInformations(targetNode.getBasicInfos());
			payload.setAddConnectionIfNotExist(addConnection);

			MoveEnpointToNodeResponse response = sourceNode.getAdminClient().moveEnpointToNode(payload);

			if(response.isSetGenericEndpoint()) {
				if(addConnection) {
					sourceNode.getNeighbourNodeNames().add(targetNode.getQName());
				}

				// remove on source node
				if(endpoint instanceof ClientEndpointProxy) {
					sourceNode.getClientEndpointProxies().remove(endpoint);
				}

				if(endpoint instanceof ProviderEndpointProxy) {
					sourceNode.getProviderEndpointProxies().remove(endpoint);
				}

				// add on target node
				if(endpoint instanceof ClientEndpointProxy) {
					targetNode.getClientEndpointProxies().add((ClientEndpointProxy) endpoint);
				}

				if(endpoint instanceof ProviderEndpointProxy) {
					targetNode.getProviderEndpointProxies().add((ProviderEndpointProxy) endpoint);
				}
			}

		} catch(ESBException e) {
			throw new WSOUIClientException(e);
		} catch (ManagementException e) {
			throw new WSOUIClientException(e);
		} 
	}


	@Override
	public Document getStateOfNode(Node node) throws WSOUIClientException {
		Document doc = null;
		try {
			doc = node.getStateOfNode();
			com.ebmwebsourcing.easyesb.soa10.api.element.Node response = (com.ebmwebsourcing.easyesb.soa10.api.element.Node) SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(doc, com.ebmwebsourcing.easyesb.soa10.api.element.Node.class);
			node.analyzeState((EJaxbNodeType) response.getInternalModel());

			boolean found = false;
			for(ProviderEndpointProxy pep: node.getProviderEndpointProxies()) {
				found = false;
				for(MockService service: this.webServices) {
					for(MockEndpoint endpoint: service.getEndpoints()) {
						if(pep.getEndpoint().getName().equals(endpoint.getName())) {
							found = true;
						}
					}
				}
				if(!found) {
					this.webServices.add(new MockServiceImpl(pep.getService()));
				}
			}
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		} catch (XmlObjectReadException e) {
			throw new WSOUIClientException(e);
		}
		return doc;

	}

	@Override
	public void connectMonitoringToEsb(Node monitoring, Node esb) throws WSOUIClientException {
		try {
			// add properties on monitoring node
			AdminClient monitoringClient = monitoring.getAdminClient();
			AddProperties monitoringProperties = new AddProperties();
			EJaxbPropertyType esbConnexionProperty = new EJaxbPropertyType();
			esbConnexionProperty.setKey(Constants.ESB_CONNEXION_PROPERTY);
			esbConnexionProperty.setValue(esb.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
			monitoringProperties.getProperty().add(esbConnexionProperty);
			monitoringClient.addProperties(monitoringProperties);

			// add properties on functionnal node
			AdminClient esbClient = esb.getAdminClient();
			AddProperties esbProperties = new AddProperties();
			EJaxbPropertyType wsdmEndpointCreationProperty = new EJaxbPropertyType();
			wsdmEndpointCreationProperty.setKey(RawReportIntializationInterceptor.RAWREPORT_ENDPOINT_CREATION_SERVICE_ADDRESS_PROPERTY);
			wsdmEndpointCreationProperty.setValue(monitoring.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
			esbProperties.getProperty().add(wsdmEndpointCreationProperty);
			EJaxbPropertyType dispatcherServiceAddressProperty = new EJaxbPropertyType();
			dispatcherServiceAddressProperty.setKey(RawReportIntializationInterceptor.RAWREPORT_SERVICE_ADDRESS_PROPERTY);
			dispatcherServiceAddressProperty.setValue(monitoring.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString().replace("adminExternalEndpoint?wsdl", DataCollectorComponentCreationFactory.DISPATCHER_PROVIDER_ENDPOINT_NAME + "ClientProxyEndpoint"));
			esbProperties.getProperty().add(dispatcherServiceAddressProperty);
			esbClient.addProperties(esbProperties);

			// add link
			monitoring.getMonitoredNodes().add(esb);

		} catch (MalformedURLException e) {
			throw new WSOUIClientException(e);
		} catch (ManagementException e) {
			throw new WSOUIClientException(e);
		}


	}

	@Override
	public List<Node> getMonitoringNodes() {
		List<Node> res = new ArrayList<Node>();
		for(Node n: this.nodes) {
			if(n.isMonitoringNode()) {
				res.add(n);
			}
		}
		return res;
	}

	@Override
	public List<Node> getEsbNodes() {
		List<Node> res = new ArrayList<Node>();
		for(Node n: this.nodes) {
			if(!n.isMonitoringNode()) {
				res.add(n);
			}
		}
		return res;
	}

	@Override
	public GovNode getGovNode() {
		return this.govNode;
	}

	@Override
	public void createGovernance(String name, String namespace, String host, String port) throws GovException {
		com.petalslink.easiergov.config.Configuration conf = new com.petalslink.easiergov.config.ConfigurationImpl();

		conf.setName(name);
		conf.setNamespace(namespace);
		conf.setHost(host);
		conf.setPort(Integer.valueOf(port));

		Container container = new WSContainer(conf);
		container.start();

		try {
			govNode = new GovNodeImpl("http://" + conf.getHost() + ":" + conf.getPort() + "/services/adminManager", this);
			this.govNode.setModel(container);
		} catch (SOAPException e) {
			throw new GovException(e);
		}

	}

	@Override
	public void bindWebServiceToNode(MockEndpoint wsToBind, Node selectedNode) throws ESBException {
		AdminClient esbClient;
		try {
			esbClient = new AdminClientImpl(selectedNode.getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
			esbClient.importSoapEndpoint(wsToBind.getAddress(), wsToBind.getService().getDescription().getDocumentBaseURI().toString());

			this.getStateOfNode(selectedNode);
		} catch (MalformedURLException e) {
			throw new ESBException(e);
		} catch (ManagementException e) {
			throw new ESBException(e);
		} catch (WSOUIClientException e) {
			throw new ESBException(e);
		}

	}

	@Override
	public void refreshConnectionBetweenFramework() throws WSOUIClientException {
		if(this.govNode != null) {
			this.govNode.refreshConnectedNodes();
		}
		for(Node n: this.getAllNodes()) {
			n.refreshMonitoredNodes();
		}

	}
}
