/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MoveEndpointToNodeFrame.java
 *
 * Created on 21 mars 2011, 13:09:52
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;

import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.topology.InternalEndpointG;

/**
 *
 * @author nsalatge
 */
public class MoveEndpointToNodeFrame extends javax.swing.JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	private WSOUIClient client;
	private Registry registry;

	private InternalEndpointG endpointToMove;
	private Node selectedNode = null;

	/** Creates new form MoveEndpointToNodeFrame */
	public MoveEndpointToNodeFrame(WSOUIClient client, InternalEndpointG endpointToMove) {
		initComponents();
		if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
		this.jCheckBoxAddConnexion.setOpaque(false);
		
		this.client = client;
		this.registry = client.getRegistry();

		this.endpointToMove = endpointToMove;
		this.setTitle("Move endpoint " + this.endpointToMove.getQName().getLocalPart() + " on node");
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
		this.jLabelMoveEndpointValue.setText(this.endpointToMove.getQName().getLocalPart());

		this.jCheckBoxAddConnexion.setSelected(true);
		this.jListNodes.setModel(new NodeListModel(this.registry.getEsbNodes()));
		this.setLocation();
	}


	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelMoveEndpointOnNode = new javax.swing.JLabel();
        jScrollPaneListNodes = new javax.swing.JScrollPane();
        jListNodes = new javax.swing.JList();
        jCheckBoxAddConnexion = new javax.swing.JCheckBox();
        jButtonOK = new javax.swing.JButton();
        jLabelMoveEndpoint = new javax.swing.JLabel();
        jLabelMoveEndpointValue = new javax.swing.JLabel();
        jLabelToNode = new javax.swing.JLabel();
        jLabelToNodeValue = new javax.swing.JLabel();

        jLabelMoveEndpointOnNode.setText("Move endpoint on node:");

        jListNodes.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jListNodes.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListNodesMouseClicked(evt);
            }
        });
        jScrollPaneListNodes.setViewportView(jListNodes);

        jCheckBoxAddConnexion.setText("Add connexion between nodes if not exist?");

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jLabelMoveEndpoint.setText("Move endpoint:");

        jLabelToNode.setText("to node:");

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 600, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addComponent(jScrollPaneListNodes, javax.swing.GroupLayout.PREFERRED_SIZE, 161, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGap(34, 34, 34)
                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jLabelMoveEndpoint)
                                .addComponent(jCheckBoxAddConnexion)
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                    .addGap(32, 32, 32)
                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jLabelMoveEndpointValue, javax.swing.GroupLayout.DEFAULT_SIZE, 353, Short.MAX_VALUE)
                                        .addGroup(jPanelMainLayout.createSequentialGroup()
                                            .addGap(10, 10, 10)
                                            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(jLabelToNode)
                                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                                    .addGap(10, 10, 10)
                                                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                        .addComponent(jLabelToNodeValue, javax.swing.GroupLayout.PREFERRED_SIZE, 333, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                        .addComponent(jButtonOK)))))))))
                        .addComponent(jLabelMoveEndpointOnNode))
                    .addContainerGap()))
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 346, Short.MAX_VALUE)
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addGroup(jPanelMainLayout.createSequentialGroup()
                            .addGap(77, 77, 77)
                            .addComponent(jLabelMoveEndpoint)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelMoveEndpointValue, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelToNode)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jLabelToNodeValue, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jCheckBoxAddConnexion)
                            .addGap(78, 78, 78)
                            .addComponent(jButtonOK))
                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelMainLayout.createSequentialGroup()
                            .addComponent(jLabelMoveEndpointOnNode)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jScrollPaneListNodes, javax.swing.GroupLayout.PREFERRED_SIZE, 304, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 600, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(0, 0, Short.MAX_VALUE)
                    .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(0, 0, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 346, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(0, 0, Short.MAX_VALUE)
                    .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(0, 0, Short.MAX_VALUE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
		try {
			this.registry.moveEndpointToNode(this.endpointToMove.getModel(), this.selectedNode, this.jCheckBoxAddConnexion.isSelected());
			this.setVisible(false);
			this.client.getTopology().repaint();
		} catch (WSOUIClientException e) {
			e.printStackTrace();
        	JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"MoveEndpointToNode Interrupted", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButtonOKActionPerformed

	private void jListNodesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListNodesMouseClicked
		this.selectedNode = (Node) this.jListNodes.getSelectedValue();
		this.jLabelToNodeValue.setText(this.selectedNode.getQName().getLocalPart());
	}//GEN-LAST:event_jListNodesMouseClicked

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new MoveEndpointToNodeFrame(null, null).setVisible(true);
			}
		});
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOK;
    private javax.swing.JCheckBox jCheckBoxAddConnexion;
    private javax.swing.JLabel jLabelMoveEndpoint;
    private javax.swing.JLabel jLabelMoveEndpointOnNode;
    private javax.swing.JLabel jLabelMoveEndpointValue;
    private javax.swing.JLabel jLabelToNode;
    private javax.swing.JLabel jLabelToNodeValue;
    private javax.swing.JList jListNodes;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JScrollPane jScrollPaneListNodes;
    // End of variables declaration//GEN-END:variables

}
