package org.petalslink.easiestdemo.wsoui.provided;

import java.net.URL;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;



public class AbstractImplementationManager<I> {
	
	private AbstractTestImplementation testImplementation = null;
	
	private WSOUIProvider guiImplementation = null;
	
	private ProviderConfiguration configuration = null;;
	

	public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl) throws WSOUIException {
			this.testImplementation = impl;
			this.guiImplementation = new WSOUIProvider(this, wsdl, null);
			this.configuration = new ProviderConfiguration();
	}

	public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl, ProviderConfiguration configuration) throws WSOUIException {
		this.testImplementation = impl;
		this.configuration = configuration;
		this.guiImplementation = new WSOUIProvider(this, wsdl, configuration);
	}
	
	public boolean isActivateGUI() {
		return configuration.isActiveGui();
	}

	public void setActivateGUI(boolean activateGUI) {
		this.configuration.setActiveGui(activateGUI);
	}
	
	public I getTestImplementation() {
		return (I) testImplementation;
	}
	
	public WSOUIProvider getGuiImplementation() {
		return guiImplementation;
	}
	
	public Description getDescription() {
		return this.guiImplementation.getDescription();
	}
	 
	public ProviderConfiguration getConfiguration() {
		return configuration;
	}

}
