/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.provided;

import java.net.URL;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIProvider;

public class AbstractImplementationManager<I> {
    private AbstractTestImplementation testImplementation = null;
    private WSOUIProvider guiImplementation = null;
    private ProviderConfiguration configuration = null;
    private URL wsdl = null;

    public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl) throws WSOUIException {
        this.testImplementation = impl;
        this.wsdl = wsdl;
        this.configuration = new ProviderConfiguration();
    }

    public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl, ProviderConfiguration configuration) throws WSOUIException {
        this.testImplementation = impl;
        this.wsdl = wsdl;
        this.configuration = configuration;
    }

    public boolean isActivateGUI() {
        return this.configuration.isActiveGui();
    }

    public void setActivateGUI(boolean activateGUI) {
        this.configuration.setActiveGui(activateGUI);
    }

    public I getTestImplementation() {
        return (I)this.testImplementation;
    }

    public WSOUIProvider getGuiImplementation() {
        if (this.guiImplementation == null) {
            try {
                this.guiImplementation = new WSOUIProvider(this, this.wsdl, this.configuration);
            }
            catch (WSOUIException e) {
                e.printStackTrace();
            }
        }
        return this.guiImplementation;
    }

    public Description getDescription() {
        return this.getGuiImplementation().getDescription();
    }

    public ProviderConfiguration getConfiguration() {
        return this.configuration;
    }
}

