/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.provided;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.text.EditorKit;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Fault;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Output;
import org.petalslink.easiestdemo.client.gui.edit.XMLEditorKit;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSOUIProvider
extends JFrame {
    private static Logger LOG = Logger.getLogger(WSOUIProvider.class.getName());
    private static final String OUT = "out";
    private static final URL BACKGROUND_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/fond_ecran_sombre_572x972.png");
    private static final URL DEFAULT_PROVIDER_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/provider.png");
    private static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");
    private Description description = null;
    private DefaultListModel model = new DefaultListModel();
    public String responseType = "out";
    private String _serviceName = null;
    private String _endpointName = null;
    private Object _request = null;
    private Object response = null;
    private String _operationName;
    private Class<?> expectedReturnType = null;
    private com.ebmwebsourcing.easyschema10.api.element.Element responseDefinition = null;
    private WSOUIJaxbContextItf wsouiContext = null;
    private ProviderConfiguration configuration = null;
    private JButton jButtonSendResponse;
    private JEditorPane jEditorPaneRequest;
    private JEditorPane jEditorPaneResponse;
    private JLabel jLabel1;
    private JLabel jLabelEndpointName;
    private JLabel jLabelImage;
    private JLabel jLabelInterfaceQName;
    private JLabel jLabelOperationName;
    private JLabel jLabelServiceQName;
    private JList jList1;
    private JPanel jPanelCommand;
    private JPanel jPanelImage;
    private JPanel jPanelMain;
    private JPanel jPanelRequest;
    private JPanel jPanelResponse;
    private JPanel jPanelServiceInformations;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneMain;
    private JScrollPane jScrollPaneRequest;
    private JScrollPane jScrollPaneResponse;
    private JTextField jTextFieldEndpointName;
    private JTextField jTextFieldInterfaceQName;
    private JTextField jTextFieldOperationName;
    private JTextField jTextFieldServiceQName;

    public WSOUIProvider(AbstractImplementationManager<?> im, URL wsdlUrl, ProviderConfiguration configuration) throws WSOUIException {
        this.initComponents();
        this.jEditorPaneRequest.setEditorKit((EditorKit)new XMLEditorKit());
        this.jEditorPaneResponse.setEditorKit((EditorKit)new XMLEditorKit());
        this.setBackground(new Color(204, 102, 255));
        this.configuration = configuration;
        if (im != null) {
            this.setTitle(im.getTestImplementation().getClass().getInterfaces()[0].getSimpleName());
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));
        if (wsdlUrl != null) {
            try {
                Definitions definitions = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(wsdlUrl, Definitions.class);
                this.description = (Description)Factory.getInstance().wrap((XmlObject)definitions);
            }
            catch (XmlObjectReadException e) {
                throw new WSOUIException(e);
            }
        }
        if (this.configuration != null && this.configuration.getPosition() != null) {
            this.setLocation(configuration.getPosition());
        } else {
            this.setLocation(ProviderConfiguration.PositionType.NORTH_WEST);
        }
    }

    public JEditorPane getjEditorPaneResponse() {
        return this.jEditorPaneResponse;
    }

    private void initComponents() {
        this.jScrollPaneMain = new JScrollPane();
        this.jPanelMain = new JPanel();
        this.jPanelRequest = new JPanel();
        this.jScrollPaneRequest = new JScrollPane();
        this.jEditorPaneRequest = new JEditorPane();
        this.jPanelServiceInformations = new JPanel();
        this.jLabelServiceQName = new JLabel();
        this.jTextFieldServiceQName = new JTextField();
        this.jLabelInterfaceQName = new JLabel();
        this.jTextFieldInterfaceQName = new JTextField();
        this.jLabelEndpointName = new JLabel();
        this.jTextFieldEndpointName = new JTextField();
        this.jLabelOperationName = new JLabel();
        this.jTextFieldOperationName = new JTextField();
        this.jPanelResponse = new JPanel();
        this.jScrollPaneResponse = new JScrollPane();
        this.jEditorPaneResponse = new JEditorPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jPanelCommand = new JPanel();
        this.jButtonSendResponse = new JButton();
        this.jPanelImage = new JPanel();
        this.jLabelImage = new JLabel();
        this.setDefaultCloseOperation(3);
        this.jScrollPaneMain.setViewportBorder(new SoftBevelBorder(0));
        this.jScrollPaneMain.setHorizontalScrollBar(null);
        this.jPanelMain.setBackground(new Color(220, 232, 232));
        this.jPanelRequest.setBorder(BorderFactory.createTitledBorder("Request:"));
        this.jPanelRequest.setOpaque(false);
        this.jScrollPaneRequest.setViewportView(this.jEditorPaneRequest);
        GroupLayout jPanelRequestLayout = new GroupLayout(this.jPanelRequest);
        this.jPanelRequest.setLayout(jPanelRequestLayout);
        jPanelRequestLayout.setHorizontalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelRequestLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneRequest, -2, 762, -2).addContainerGap(148, Short.MAX_VALUE)));
        jPanelRequestLayout.setVerticalGroup(jPanelRequestLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneRequest, -1, 173, Short.MAX_VALUE));
        this.jPanelServiceInformations.setBorder(BorderFactory.createTitledBorder("Service Informations"));
        this.jPanelServiceInformations.setOpaque(false);
        this.jLabelServiceQName.setText("Service QName:");
        this.jTextFieldServiceQName.setEditable(false);
        this.jLabelInterfaceQName.setText("Interface QName:");
        this.jTextFieldInterfaceQName.setEditable(false);
        this.jLabelEndpointName.setText("Endpoint Name:");
        this.jTextFieldEndpointName.setEditable(false);
        this.jLabelOperationName.setText("Operation Name:");
        this.jTextFieldOperationName.setEditable(false);
        GroupLayout jPanelServiceInformationsLayout = new GroupLayout(this.jPanelServiceInformations);
        this.jPanelServiceInformations.setLayout(jPanelServiceInformationsLayout);
        jPanelServiceInformationsLayout.setHorizontalGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelServiceInformationsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelInterfaceQName).addComponent(this.jLabelServiceQName).addComponent(this.jLabelEndpointName).addComponent(this.jLabelOperationName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldOperationName).addComponent(this.jTextFieldEndpointName).addComponent(this.jTextFieldInterfaceQName).addComponent(this.jTextFieldServiceQName, -1, 646, Short.MAX_VALUE)).addContainerGap(145, Short.MAX_VALUE)));
        jPanelServiceInformationsLayout.setVerticalGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelServiceInformationsLayout.createSequentialGroup().addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelServiceQName).addComponent(this.jTextFieldServiceQName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelInterfaceQName).addComponent(this.jTextFieldInterfaceQName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEndpointName).addComponent(this.jTextFieldEndpointName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelServiceInformationsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOperationName).addComponent(this.jTextFieldOperationName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelResponse.setBorder(BorderFactory.createTitledBorder("Response:"));
        this.jPanelResponse.setOpaque(false);
        this.jScrollPaneResponse.setViewportView(this.jEditorPaneResponse);
        this.jList1.setModel(this.model);
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WSOUIProvider.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel1.setText("Response type");
        GroupLayout jPanelResponseLayout = new GroupLayout(this.jPanelResponse);
        this.jPanelResponse.setLayout(jPanelResponseLayout);
        jPanelResponseLayout.setHorizontalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelResponseLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneResponse, -2, 762, -2).addGap(27, 27, 27).addGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 107, -2).addComponent(this.jLabel1)).addGap(407, 407, 407)));
        jPanelResponseLayout.setVerticalGroup(jPanelResponseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneResponse, -1, 189, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanelResponseLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(10, 10, 10).addComponent(this.jScrollPane1, -2, -1, -2).addGap(11, 11, 11)));
        this.jPanelCommand.setOpaque(false);
        this.jButtonSendResponse.setText("Send");
        this.jButtonSendResponse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WSOUIProvider.this.jButtonSendResponseActionPerformed(evt);
            }
        });
        GroupLayout jPanelCommandLayout = new GroupLayout(this.jPanelCommand);
        this.jPanelCommand.setLayout(jPanelCommandLayout);
        jPanelCommandLayout.setHorizontalGroup(jPanelCommandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelCommandLayout.createSequentialGroup().addContainerGap(812, Short.MAX_VALUE).addComponent(this.jButtonSendResponse, -2, 121, -2).addContainerGap()));
        jPanelCommandLayout.setVerticalGroup(jPanelCommandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCommandLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonSendResponse, -1, 37, Short.MAX_VALUE).addContainerGap()));
        this.jPanelImage.setOpaque(false);
        this.jLabelImage.setHorizontalAlignment(0);
        GroupLayout jPanelImageLayout = new GroupLayout(this.jPanelImage);
        this.jPanelImage.setLayout(jPanelImageLayout);
        jPanelImageLayout.setHorizontalGroup(jPanelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelImageLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelImage, -1, 170, Short.MAX_VALUE).addContainerGap()));
        jPanelImageLayout.setVerticalGroup(jPanelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelImageLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelImage, -1, 144, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelCommand, -2, -1, -2).addGroup(jPanelMainLayout.createSequentialGroup().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanelServiceInformations, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelRequest, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelResponse, GroupLayout.Alignment.LEADING, -1, 942, Short.MAX_VALUE)).addGap(375, 375, 375).addComponent(this.jPanelImage, -2, -1, -2))).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelServiceInformations, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelImage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelRequest, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelResponse, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelCommand, -2, -1, -2).addContainerGap()));
        this.jScrollPaneMain.setViewportView(this.jPanelMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneMain, -2, 997, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneMain, -2, 700, -2));
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        this.listHandler(evt);
    }

    private void jButtonSendResponseActionPerformed(ActionEvent evt) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.jEditorPaneResponse.getText().getBytes());
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            ((InputStream)is).close();
            Class<?> clazz = this.getWsouiContext().findJaxClassFromElementQName(this.responseDefinition.inferQName());
            this.response = this.getWsouiContext().unmarshallAnyType(doc, clazz);
            this.getFrame().setVisible(false);
        }
        catch (SAXException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
            e1.printStackTrace();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
            e1.printStackTrace();
        }
        catch (ParserConfigurationException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
            e1.printStackTrace();
        }
        catch (WSOUIException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
            e1.printStackTrace();
        }
    }

    private JFrame getFrame() {
        return this;
    }

    public String getResponseType() {
        return this.responseType;
    }

    private void setLocation(ProviderConfiguration.PositionType position) {
        double witdhFrame = this.getBounds().getWidth();
        double heightFrame = this.getBounds().getHeight();
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int x = 0;
        int y = 0;
        try {
            if (position.equals((Object)ProviderConfiguration.PositionType.NORTH_WEST)) {
                x = 0 + new Random().nextInt((int)(witdhScreen / 2.0 - witdhFrame / 2.0));
                y = 0 + new Random().nextInt((int)(heightScreen / 2.0 - heightFrame / 2.0));
            } else if (position.equals((Object)ProviderConfiguration.PositionType.NORTH_EAST)) {
                x = 0 + new Random().nextInt((int)(witdhScreen / 2.0 - witdhFrame / 2.0)) + (int)(witdhScreen / 2.0) - (int)(witdhFrame / 2.0);
                y = 0 + new Random().nextInt((int)(heightScreen / 2.0 - heightFrame / 2.0));
            } else if (position.equals((Object)ProviderConfiguration.PositionType.SOUTH_WEST)) {
                x = 0 + new Random().nextInt((int)(witdhScreen / 2.0 - witdhFrame / 2.0));
                y = 0 + new Random().nextInt((int)(heightScreen / 2.0 - heightFrame / 2.0)) + (int)(heightScreen / 2.0) - (int)(heightFrame / 2.0);
            } else if (position.equals((Object)ProviderConfiguration.PositionType.SOUTH_EAST)) {
                x = 0 + new Random().nextInt((int)(witdhScreen / 2.0 - witdhFrame / 2.0)) + (int)(witdhScreen / 2.0) - (int)(witdhFrame / 2.0);
                y = 0 + new Random().nextInt((int)(heightScreen / 2.0 - heightFrame / 2.0)) + (int)(heightScreen / 2.0) - (int)(heightFrame / 2.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.setLocation(x, y);
    }

    public Object getResponse() {
        Collection methods;
        if (this.response != null && !this.response.getClass().getName().equals(this.expectedReturnType.getName()) && this.expectedReturnType.getName().equals(String.class.getName()) && (methods = ReflectionHelper.findMethodsThatReturnType(this.response.getClass(), this.expectedReturnType)).size() > 1) {
            Method m = (Method)methods.iterator().next();
            try {
                this.response = ReflectionHelper.invokeMethod((Object)this.response, (Method)m, (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this.response;
    }

    public void setExchangeInformations(String serviceName, String endpointName, String operationName, Object request, Object response, Class<?> expectedReturnType, String responseType) {
        this._serviceName = serviceName;
        this._endpointName = endpointName;
        this._operationName = operationName;
        this._request = request;
        this.response = response;
        this.jTextFieldServiceQName.setText(serviceName);
        this.jTextFieldEndpointName.setText(endpointName);
        this.jTextFieldOperationName.setText(operationName);
        this.expectedReturnType = expectedReturnType;
        Endpoint ep = this.description.findEndpoint(endpointName);
        this.jTextFieldInterfaceQName.setText(ep.getBinding().getInterface().getQName().toString());
        Operation op = null;
        for (Operation operation : ep.getBinding().getInterface().getOperations()) {
            if (!operation.getName().toLowerCase().equals(operationName.toLowerCase())) continue;
            op = operation;
        }
        if (op != null) {
            this.fillResponseList(ep.getBinding().getInterface().getQName(), op.inferQName());
            com.ebmwebsourcing.easyschema10.api.element.Element inputElmt = op.getInput().getElement();
            this.responseDefinition = op.getOutput().getElement();
            if (OUT.equals(this.responseType)) {
                this.responseDefinition = op.getOutput().getElement();
            } else {
                for (int i = 0; i < op.getFaults().length; ++i) {
                    if (!responseType.equals(op.getFaults()[i].getName())) continue;
                    this.responseDefinition = op.getFaults()[i].getMessage();
                }
            }
            String requestDOM = this.createDocument(request, inputElmt);
            String responseDOM = this.createDocument(response, this.responseDefinition);
            this.jEditorPaneRequest.setText(requestDOM);
            this.jEditorPaneResponse.setText(responseDOM);
        } else {
            JOptionPane.showMessageDialog(this, "Impossible to find in interface " + ep.getBinding().getInterface().getQName() + " an operation corresponding to " + operationName, "Error", 0);
        }
        this.setAlwaysOnTop(true);
        this.validate();
    }

    private void fillResponseList(QName itfName, QName operation) {
        this.model.removeAllElements();
        ArrayList<String> datalist = new ArrayList<String>();
        Interface itf = this.description.findInterface(itfName);
        Output out = itf.getOperation(operation).getOutput();
        if (out != null) {
            datalist.add(OUT);
            this.model.addElement(OUT);
        }
        Fault[] faults = itf.getOperation(operation).getFaults();
        for (int i = 0; i < faults.length; ++i) {
            datalist.add(faults[i].getName());
            this.model.addElement(faults[i].getName());
        }
    }

    private String createDocument(Object msg, com.ebmwebsourcing.easyschema10.api.element.Element def) {
        String res = null;
        try {
            Document doc = null;
            if (msg instanceof ModelObject) {
                doc = this.getWsouiContext().marshallAnyElement(msg);
                res = XMLPrettyPrinter.prettyPrint((Document)doc);
            } else if (msg instanceof GetResourcePropertyResponse) {
                doc = this.getWsouiContext().marshallAnyElement(msg);
                res = XMLPrettyPrinter.prettyPrint((Document)doc);
            } else {
                doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                QName elmtName = new QName(SchemaHelper.findParentSchema((XmlObject)def).getTargetNamespace(), def.getName());
                Type t = def.findType();
                if (t instanceof ComplexType) {
                    ComplexType ct = (ComplexType)t;
                    if (ct.getSequence() != null && ct.getSequence().getElements().length == 1) {
                        elmtName = ct.getSequence().getElements()[0].inferQName();
                    } else if (ct.getAll() != null && ct.getAll().getElements().length == 1) {
                        elmtName = ct.getAll().getElements()[0].inferQName();
                    }
                }
                Element root = doc.createElementNS(elmtName.getNamespaceURI(), elmtName.getLocalPart());
                if (msg != null) {
                    root.setNodeValue(msg.toString());
                    doc.appendChild(root);
                    res = XMLPrettyPrinter.prettyPrint((Document)doc);
                } else {
                    res = XSD2XML.newInstance().printXml(def, (Object)"?");
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (WSOUIException e) {
            e.printStackTrace();
        }
        if (res != null) {
            res = res.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", "");
        } else {
            LOG.warning("Impossible to convert into document, the objet: \n" + msg + "\n from this definition: " + def);
        }
        return res;
    }

    public WSOUIJaxbContextItf getWsouiContext() {
        return this.wsouiContext;
    }

    public void setWsouiContext(WSOUIJaxbContextItf wsouiContext) {
        this.wsouiContext = wsouiContext;
    }

    public Description getDescription() {
        return this.description;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new WSOUIProvider(null, null, null).setVisible(true);
                }
                catch (WSOUIException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void listHandler(MouseEvent evt) {
        this.responseType = (String)this.jList1.getSelectedValue();
        this.updateExchangeInformations();
    }

    public void updateExchangeInformations() {
        this.setExchangeInformations(this._serviceName, this._endpointName, this._operationName, this._request, this.response, this.expectedReturnType, this.responseType);
    }
}

