/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.util;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractSOAJAXBContext
implements WSOUIJaxbContextItf {
    private JAXBContext jaxbContext;
    private List<Class> currentObjectFactories = new ArrayList<Class>();

    protected AbstractSOAJAXBContext() throws WSOUIException {
        SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]));
        }
        catch (JAXBException e) {
            throw new WSOUIException(e);
        }
    }

    protected synchronized void addOtherObjectFactory(Class<?> ... list) throws WSOUIException {
        if (list != null) {
            for (Class<?> clazz : list) {
                if (this.currentObjectFactories.contains(clazz)) continue;
                this.currentObjectFactories.add(clazz);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]));
            }
            catch (JAXBException e) {
                e.printStackTrace();
                throw new WSOUIException(e);
            }
        }
    }

    private JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    @Override
    public <T> T unmarshallAnyType(Document doc, Class<T> clazz) throws WSOUIException {
        Object res = null;
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            JAXBElement binding = unmarshaller.unmarshal((Node)doc, clazz);
            res = binding.getValue();
        }
        catch (JAXBException e) {
            throw new WSOUIException(e);
        }
        return (T)res;
    }

    @Override
    public <E> Document marshallAnyType(QName tag, E jaxbElmt, Class<E> clazz) throws WSOUIException {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            JAXBElement element = new JAXBElement(tag, clazz, jaxbElmt);
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new WSOUIException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new WSOUIException(ex);
        }
        return doc;
    }

    @Override
    public Document marshallAnyElement(Object jaxbElmt) throws WSOUIException {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            marshaller.marshal(jaxbElmt, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new WSOUIException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new WSOUIException(ex);
        }
        return doc;
    }

    @Override
    public Class<?> findJaxClassFromElementQName(QName element) {
        Class<?> res = null;
        for (Class clazz : this.currentObjectFactories) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().toLowerCase().contains("create" + element.getLocalPart().toLowerCase())) continue;
                res = m.getReturnType();
            }
        }
        return res;
    }
}

