package org.petalslink.easiestdemo.wsoui.plugin.wsdl;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import com.ebmwebsourcing.easycommons.uri.URIHelper;


public class WSOUIBindingGenerator {

    private static int cpt = 0;

    private WsdlOption wsdlOption;

    public WSOUIBindingGenerator(WsdlOption wsdlOption) throws WSOUIException {
        this.wsdlOption = wsdlOption;
    }

    public List<URI> generateBindings(String wsdlUrl, URI basedir) throws IOException, URISyntaxException {
        List<URI> files = new ArrayList<URI>();
        files.add(this.generateJAXWSBinding(wsdlUrl, basedir).toURI());
        files.add(this.generateJXBBinding(wsdlUrl, basedir).toURI());

        cpt++;
        return files;
    }


    private File generateJAXWSBinding(String wsdlUrl, URI basedir) throws IOException {
        String name = basedir.toString().replace("./", "") + "target" + "/wsouibinding_jaxws_" + cpt + ".xjb";
        File f = new File(URI.create(name));
        f.createNewFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);

            // create package
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\r\n" + 
                    "<jaxws:bindings\r\n" + 
                    "    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n" + 
                    "    xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\r\n" + 
                    "	 wsdlLocation=\"" + FileUtil.getURI(basedir, wsdlUrl).toString() + "\"\r\n" + 
                    "    xmlns=\"http://java.sun.com/xml/ns/jaxws\"\r\n" + 
                    "    xmlns:jaxws=\"http://java.sun.com/xml/ns/jaxws\">\r\n" + 
                    "    <enableWrapperStyle>false</enableWrapperStyle>\r\n");
            writer.write("</jaxws:bindings>\r\n");

        } finally{
            if(writer != null){
                writer.close();
            }
        }

        return f;
    }

    private File generateJXBBinding(String wsdlUrl, URI basedir) throws IOException {
        String name = basedir.toString().replace("./", "") + "target" + "/wsouibinding_jxb_" + cpt + ".xjb";
        File f = new File(URI.create(name));
        f.createNewFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            // create package
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\r\n" + 
                    "<jxb:bindings\r\n" + 
                    "    version=\"1.0\"" +
                    "    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n" + 
                    "    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n" +
                    "    xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\r\n" + 
                    "    xmlns:xjc=\"http://java.sun.com/xml/ns/jaxb/xjc\"\r\n" +
                    "    jxb:extensionBindingPrefixes=\"xjc\"\r\n" + 
                    "    xmlns:jxb=\"http://java.sun.com/xml/ns/jaxb\">\r\n" +
                    "    <!-- CAUTION : generateIsSetMethod set to true is mandatory for easybox\r\n" + 
                    "        ! -->\r\n" + 
                    "    <jxb:globalBindings generateElementClass=\"false\"\r\n" + 
                    "        generateIsSetMethod=\"true\">\r\n" + 
                    "        <xjc:superClass name=\"com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject\" />\r\n" + 
                    "    </jxb:globalBindings> \r\n" + 
                    "    \r\n");  
            if(this.wsdlOption.getRelatifEventImport() != null) {
                writer.write("" +
                        "    <jxb:bindings schemaLocation=\"" + URIHelper.resolve(this.wsdlOption.getRelatifEventImport(), "./standard/wsrf/bf-2.xsd") + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"com.ebmwebsourcing.wsstar.jaxb.resource.basefaults\" />\r\n" + 
                        "        </jxb:schemaBindings>\r\n" + 
                        "    </jxb:bindings>\r\n" + 
                        "    \r\n" + 
                        "    <jxb:bindings schemaLocation=\"" + URIHelper.resolve(this.wsdlOption.getRelatifEventImport(), "./standard/wsn/b-2.xsd") + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"com.ebmwebsourcing.wsstar.jaxb.notification.base\" />\r\n" + 
                        "        </jxb:schemaBindings>\r\n" + 
                        "    </jxb:bindings>\r\n" + 
                        "\r\n" + 
                        "    <jxb:bindings schemaLocation=\"" + URIHelper.resolve(this.wsdlOption.getRelatifEventImport(), "./standard/wsrf/r-2.xsd") + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"com.ebmwebsourcing.wsstar.jaxb.resource.resource\" />\r\n" + 
                        "        </jxb:schemaBindings>\r\n" + 
                        "    </jxb:bindings>\r\n" + 
                        "    \r\n" + 
                        "    <jxb:bindings schemaLocation=\"" + URIHelper.resolve(this.wsdlOption.getRelatifEventImport(), "./standard/wsrf/rp-2.xsd") + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties\" />\r\n" + 
                        "        </jxb:schemaBindings>\r\n" + 
                        "    </jxb:bindings>\r\n" + 
                        "    <jxb:bindings schemaLocation=\"" + URIHelper.resolve(this.wsdlOption.getRelatifEventImport(), "./standard/wsn/t-1.xsd") + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"com.ebmwebsourcing.wsstar.jaxb.notification.topics\" />\r\n" + 
                        "        </jxb:schemaBindings>\r\n" +
                        "    </jxb:bindings>");
            }
            if(this.wsdlOption.getSchemaLocationOfWsAddressing() != null) {
                writer.write("    <jxb:bindings schemaLocation=\"" + this.wsdlOption.getSchemaLocationOfWsAddressing() + "\"\r\n" + 
                        "        node=\"/xs:schema\">\r\n" + 
                        "        <jxb:schemaBindings>\r\n" + 
                        "            <jxb:package name=\"easybox.org.w3._2005._08.addressing\" />\r\n" + 
                        "            <jxb:nameXmlTransform>\r\n" + 
                        "                <jxb:elementName prefix=\"EJaxb\" />\r\n" + 
                        "                <jxb:typeName prefix=\"EJaxb\" />\r\n" + 
                        "            </jxb:nameXmlTransform>\r\n" + 
                        "        </jxb:schemaBindings>\r\n" + 
                        "    </jxb:bindings>" + 
                        "    \r\n" );
            }

            writer.write("</jxb:bindings>\r\n");

        } catch (URISyntaxException e) {
            throw new IOException(e);
        } finally{
            if(writer != null){
                writer.close();
            }
        }

        return f;
    }

    //    private URI getWSAddressingBinding() throws IOException, URISyntaxException {
    //        if(this.wsdlOption.getSchemaLocationOfWsAddressing() != null) {
    //            return Thread.currentThread().getContextClassLoader().getResource("schema/wsaddressing10/wsaddressing10.xjb").toURI();
    //        }
    //        return null;
    //    }

}
