package org.petalslink.easiestdemo.wsoui.core.bpel;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class SCACompositeGenerator {

	private List<ImplMetaInf> allMetaInfs;
	private BPELProcess process;
	private boolean override;

	public SCACompositeGenerator(BPELProcess process, List<ImplMetaInf> allMetaInfs, boolean override) throws WSOUIException {
		this.allMetaInfs = removeDoublons(allMetaInfs);
		this.process = process;
		this.override = override;
	}


	private List<ImplMetaInf> removeDoublons(List<ImplMetaInf> allMetaInfs) {
		List<ImplMetaInf> res = new ArrayList<ImplMetaInf>();
		boolean found = false;
		for(ImplMetaInf imi: allMetaInfs) {
			found = false;
			for(ImplMetaInf imiRes: res) {
				if(imi.getClassName().equals(imiRes.getClassName())) {
					found = true;
					break;
				}
			}
			if(!found) {
				res.add(imi);
			}
		}
		return res;
	}


	public File generate(String bpelUrl, String basedir) throws IOException {
		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.process.getTargetNamespace());
		String className = this.process.getName() ;
		className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}

		File f = FileUtil.createFile(className, packageName, basedir, ".composite", true);
		

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
			writer.write("<composite xmlns=\"http://www.osoa.org/xmlns/sca/1.0\"\n");
			writer.write("\txmlns:frascati=\"http://frascati.ow2.org/xmlns/sca/1.1\" \n");
			writer.write("\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" name=\"SCA View\">\n");
			
			// create exposed service of sca composite
			for(Interface itf: this.process.getProcessInterfaces()) {
				for (Service s: itf.getParentDescription().findServicesImplementingInterface(itf)) {
					writer.write("\t<service name=\"" + s.getQName().getLocalPart() + "\" promote=\"" + s.getQName().getLocalPart() + "/" + s.getQName().getLocalPart() + "\" />\n");				
				}
			}
			
			// create bpel composite
			writer.write("\t<component name=\"" + this.process.getName() + "\">\n");
			for(Interface itf: this.process.getProcessInterfaces()) {
				for (Service s: itf.getParentDescription().findServicesImplementingInterface(itf)) {
					writer.write("\t\t<service name=\"" + s.getQName().getLocalPart() + "\" />\n");				
				}
			}
			for(ImplMetaInf imi: this.allMetaInfs) {
				writer.write("\t\t<reference name=\"" + imi.getServiceName() + "\" target=\"" + imi.getServiceName() + "/" + imi.getServiceName() + "\" />\n");
			}
			writer.write("\t</component>\n");
			
			// create web service component
			for(ImplMetaInf imi: this.allMetaInfs) {
				writer.write("\t<component name=\"" + imi.getServiceName() + "\" >\n");
				writer.write("\t\t<service name=\"" + imi.getServiceName() + "\" />\n");
				writer.write("\t</component>\n");
			}

			writer.write("</composite>\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
