package org.petalslink.easiestdemo.wsoui.provided;

import java.net.URL;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;



public class AbstractImplementationManager<I> {

	private AbstractTestImplementation testImplementation = null;

	private WSOUIProvider guiImplementation = null;

	private ProviderConfiguration configuration = null;

	private URL wsdl = null;
	
	protected Object lock = new Object();


	public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl) throws WSOUIException {
		this.testImplementation = impl;
		this.wsdl = wsdl;
		this.configuration = new ProviderConfiguration();
		if(wsdl == null) {
			throw new WSOUIException("wsdl cannot be null!!!");
		}
	}

	public AbstractImplementationManager(AbstractTestImplementation impl, URL wsdl, ProviderConfiguration configuration) throws WSOUIException {
		this.testImplementation = impl;
		this.wsdl = wsdl;
		this.configuration = configuration;
		if(wsdl == null) {
			throw new WSOUIException("wsdl cannot be null!!!");
		}
	}

	public boolean isActivateGUI() {
		return configuration.isActiveGui();
	}

	public void setActivateGUI(boolean activateGUI) {
		this.configuration.setActiveGui(activateGUI);
	}

	public I getTestImplementation() {
		return (I) testImplementation;
	}

	public WSOUIProvider getGuiImplementation() {
		if(guiImplementation==null) {
			try {
				this.guiImplementation = new WSOUIProvider(this, wsdl, configuration);
			} catch (WSOUIException e) {
				// do nothing
				e.printStackTrace();
			}
		}
		return guiImplementation;
	}

	public Description getDescription() {
		return this.getGuiImplementation().getDescription();
	}

	public ProviderConfiguration getConfiguration() {
		return configuration;
	}

	
	public synchronized Object getLock() {
		return lock;
	}
}
