/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

public class ServerMain {
    private String name;
    private String clazz;
    private String tns;
    private List<String> allServerNamesInDef;
    private static int cpt = 1;
    private String serviceClassName = null;

    public ServerMain(String tns, String name, List<String> allServerNamesInDef, boolean override) throws WSOUIException {
        this.name = name;
        this.tns = tns;
        this.allServerNamesInDef = allServerNamesInDef;
        this.serviceClassName = null;
        this.serviceClassName = name != null && name.trim().length() > 0 ? name.substring(0, 1).toUpperCase() + name.substring(1, name.length()) : String.valueOf(cpt++);
    }

    public String deduceClassName(String basedir) {
        String className = this.serviceClassName + "_Main";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        return packageName + "." + className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String basedir) throws IOException {
        String className = this.serviceClassName + "_Main";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        this.clazz = packageName + "." + className;
        File dir = new File(basedir + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".java", (boolean)true);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("import javax.xml.ws.Endpoint;\n");
            writer.write("import java.io.File;\n");
            writer.write("import java.io.InputStream;\n");
            writer.write("import java.io.FileInputStream;\n");
            writer.write("import java.util.logging.LogManager;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.abslayer.service.api.Description;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
            writer.write("\n");
            writer.write("public class " + className + " {\n");
            writer.write("\n");
            writer.write("private final static String LOGGER_FILE = \"/logger.properties\";\n");
            writer.write("\tstatic {\n");
            writer.write("\ttry {\n");
            writer.write("\t\t\tInputStream inputStream = null;\n");
            writer.write("\t\t\tFile logger = new File(\".\" + LOGGER_FILE);\n");
            writer.write("\t\t\tif (logger.exists()) {\n");
            writer.write("\t\t\t\tinputStream = new FileInputStream(logger);\n");
            writer.write("\t\t\t} else {\n");
            writer.write("\t\t\t\t// ty to get from classpath\n");
            writer.write("\t\t\t\tinputStream = " + className + ".class.getClass()\n");
            writer.write("\t\t\t\t\t\t.getResourceAsStream(LOGGER_FILE);\n");
            writer.write("\t\t\t}\n");
            writer.write("\t\t\tif (inputStream != null) {\n");
            writer.write("\t\t\t\tLogManager.getLogManager().readConfiguration(inputStream);\n");
            writer.write("\t\t\t\tinputStream.close();\n");
            writer.write("\t\t\t}\n");
            writer.write("\t\t} catch (final Exception e) {\n");
            writer.write("\t\t\tthrow new RuntimeException(\"couldn't initialize logging properly\",\n");
            writer.write("\t\t\t\t\te);\n");
            writer.write("\t\t}\n");
            writer.write("\t}\n");
            writer.write("\t\n");
            writer.write("\tpublic " + className + "() {\n");
            writer.write("\t}\n");
            writer.write("\n\n");
            writer.write("\tpublic static void main(String args[]) throws Exception {\n");
            for (String server : this.allServerNamesInDef) {
                writer.write(server + ".main(args);\n");
            }
            writer.write("\n");
            writer.write("}\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public String getClassName() {
        return this.clazz;
    }
}

