/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;

public class TestImplementationGenerator {
    private ImplMetaInf imf;
    private String tns;

    public TestImplementationGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
        this.imf = imf;
        this.tns = tns;
    }

    private String generateImplementationMethod(Method m) {
        String res = "";
        res = "       Exchange<?, ?, ?> ex = this.getExchangeProcessor().match(\"" + m.getName() + "\", " + Method.generateListOfInputParameterNames(m) + ");\r\n";
        if (!m.getOutputParam().getType().equals("void")) {
            res = res + "\t\tif(ex == null) {\r\n" + "\t\t\treturn " + Parameter.returnDefaultType(m.getOutputParam().getType()) + ";\r\n" + "\t\t}\n";
        }
        res = res + "\t\tif(ex.getExpectedFault() != null) {\r\n";
        for (String exception : m.getExceptions()) {
            res = res + "\t\t\tif(ex.getExpectedFault() instanceof " + exception + ") {\r\n" + "\t\t\t\tthrow (" + exception + ")ex.getExpectedFault();\r\n" + "\t\t\t} else ";
        }
        res = res + " {\r\n" + "\t\t\t\tthrow new RuntimeException(\"Fault unknown: \" + ex.getExpectedFault());\r\n" + "\t\t\t}\r\n" + "\t\t}\r\n";
        if (!m.getOutputParam().getType().equals("void")) {
            res = res + "\t\treturn (" + Parameter.findType(m.getOutputParam().getType()) + ") ex.getExpectedResponse();";
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String basedir) throws IOException {
        String className = this.imf.getServiceName().substring(0, 1).toUpperCase() + this.imf.getServiceName().substring(1, this.imf.getServiceName().length());
        className = className + "TestImplementation";
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.tns);
        File f = new File(basedir + "/" + packageName.replace(".", "/") + "/" + className + ".java");
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            for (String impt : this.imf.getImports()) {
                writer.write("import " + impt + ";\n");
            }
            writer.write("import " + this.imf.getSignaturePackage() + "." + this.imf.getInterfaceName() + ";\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("\n");
            writer.write("public class " + className + " extends AbstractTestImplementation implements " + this.imf.getInterfaceName() + "{\n");
            writer.write("\n");
            writer.write("\tpublic " + className + "(AbstractExchangeProcessor aep) throws WSOUIException {\n");
            writer.write("\t\tsuper(aep);\n");
            writer.write("\t}\n");
            writer.write("\n");
            for (Method m : this.imf.getSignatureMethods()) {
                writer.write("\tpublic " + m.getOutputParam().getType() + " " + m.getName() + "(");
                String inputParams = "";
                for (Parameter inputParam : m.getInputParams()) {
                    inputParams = inputParams + inputParam.getType() + " " + inputParam.getName() + ", ";
                }
                inputParams = inputParams.substring(0, inputParams.length() - ", ".length()) + ") ";
                writer.write(inputParams);
                if (m.getExceptions() != null && m.getExceptions().size() > 0) {
                    writer.write(" throws ");
                    String exceptions = "";
                    for (String exception : m.getExceptions()) {
                        exceptions = exceptions + exception + ", ";
                    }
                    exceptions = exceptions.substring(0, exceptions.length() - ", ".length());
                    writer.write(exceptions);
                }
                writer.write(" {\n");
                writer.write(this.generateImplementationMethod(m));
                writer.write("\t}\n\n\n");
            }
            writer.write("\n");
            writer.write("}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

