package org.petalslink.easiestdemo.wsoui.core.bpel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class BPELJUnitTestGenerator {

	private List<String> allServerClassNames;

	private BPELProcess process;

	public BPELJUnitTestGenerator(BPELProcess process, List<String> allServerClassNames) throws WSOUIException {
		this.allServerClassNames = allServerClassNames;
		this.process = process;
	}


	public File generate(String bpelUrl, String basedir) throws IOException {
		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.process.getTargetNamespace());
		String className = this.process.getName() + "_BPELTest";
		className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}

		File f = FileUtil.createFile(className, packageName, basedir, ".java", true);
		

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// add imports
			writer.write("import org.junit.Test;\n");
			writer.write("import org.junit.Assert;\n");
			writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;\n");
			writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;\n");
			writer.write("import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;\n");

			writer.write("\n");


			// create class
			writer.write("public class " + className + "{\n");
			writer.write("\n");



			// create read wsdl method
			writer.write("\t@Test\n");
			writer.write("\tpublic void valid" + this.process.getName().substring(0, 1).toUpperCase() + this.process.getName().substring(1, this.process.getName().length()) + "() throws Exception {\n");
			writer.write("\t\tBPELValidator validator = new BPELValidator();\n");
			writer.write("\t\tValidatorResult report = validator.validate(" + this.process.getName().substring(0, 1).toUpperCase() + this.process.getName().substring(1, this.process.getName().length()) + "_Main.BPEL_LOCATION" + ");\n");
			writer.write("\t\tif(report.getErrors().size() > 0) {\n");
			writer.write("\t\t	throw new Exception(ValidatorResultPrinter.getInstance().printAll(report));\n");
			writer.write("\t\t} else {\n");
			writer.write("\t\t	System.out.println(ValidatorResultPrinter.getInstance().printAll(report));\n");
			writer.write("\t\t}\n");
			writer.write("\t}\n");


			writer.write("\n");
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
