package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map.Entry;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Annotation;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;
import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;


public class ClientImplementationGenerator {

	private ImplMetaInf imf;

	public ClientImplementationGenerator(ImplMetaInf imf) throws WSOUIException {
		this.imf = imf;
	}



	private String generateImplementationMethod(Method m) {
		String res = "";
		res = "" + 
		"       Exchange<?, ?, ?> ex = this.getExchangeProcessor().match(\"" + m.getName() + "\", " + Method.generateListOfInputParameterNames(m) + ");\r\n" + 
		"		if(ex == null) {\r\n" + 
		"			return " + Parameter.returnDefaultType(m.getOutputParam().getType()) + ";\r\n" + 
		"		}" +
		"		if(ex.getExpectedFault() != null) {\r\n";

		for(String exception: m.getExceptions()) {
			res = res + 
			"			if(ex.getExpectedFault() instanceof " + exception + ") {\r\n" +
			"				throw (" + exception + ")ex.getExpectedFault();\r\n" + 
			"			} else ";
		}


		res = res + " {\r\n" + 
		"				throw new RuntimeException(\"Fault unknown: \" + ex.getExpectedFault());\r\n" + 
		"			}\r\n" + 
		"		}\r\n" + 
		"		return (" + Parameter.findType(m.getOutputParam().getType()) + ") ex.getExpectedResponse();";
		return res;
	}


	public File generate(String basedir) throws IOException {
		String className = imf.getClassName().replace("Impl", "TestImplementation");
		File f = new File(basedir + "/" + imf.getSignaturePackage().replace(".", "/") + "/" + className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + imf.getSignaturePackage() + ";\n");
			writer.write("\n");

			// create imports
			for(String impt: imf.getImports()) {
				writer.write("import " + impt + ";\n");
			}
			// add specific import
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
			
			writer.write("\n");


			// create class
			writer.write("public class " + className + " extends AbstractTestImplementation implements " + imf.getInterfaceName() + "{\n");
			writer.write("\n");
			
			// create constructor
			writer.write("\tpublic " + className + "(AbstractExchangeProcessor aep) throws WSOUIException {\n");
			writer.write("\t\tsuper(aep);\n");
			writer.write("\t}\n");
			writer.write("\n");
			
			// create all methods
			for(Method m: imf.getSignatureMethods()) {
				writer.write("\tpublic " + m.getOutputParam().getType() + " " + m.getName() + "(" );
				
				// create input params
				String inputParams = "";
				for(Parameter inputParam: m.getInputParams()) {
					inputParams = inputParams + inputParam.getType() + " " + inputParam.getName() + ", ";
				}
				inputParams = inputParams.substring(0, inputParams.length() - ", ".length()) + ") ";
				writer.write(inputParams);
				
				// create exception if exists
				if(m.getExceptions() != null && m.getExceptions().size() > 0) {
					writer.write(" throws ");
					String exceptions = "";
					for(String exception: m.getExceptions()) {
						exceptions = exceptions + exception + ", ";
					}
					exceptions = exceptions.substring(0, exceptions.length() - ", ".length());
					writer.write(exceptions);
				}
				writer.write(" {\n");
				writer.write(this.generateImplementationMethod(m));
				writer.write("\t}\n\n\n");
			}
			
			writer.write("\n");
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
