package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class ServerMain {

	private String name;

	private String clazz; 

	private String tns;
	
	private List<String> allServerNamesInDef;

	private static int cpt = 1;

	private String serviceClassName = null;
	
	public ServerMain(String tns, String name, List<String> allServerNamesInDef,  boolean override) throws WSOUIException {
		this.name = name;
		this.tns = tns;
		this.allServerNamesInDef = allServerNamesInDef;
		
		serviceClassName = null;
		if(name != null && name.trim().length() > 0) {
			serviceClassName = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
		} else {
			serviceClassName = String.valueOf(cpt++);
		}
	}



	public String deduceClassName(String basedir) {
		String className = serviceClassName + "_Main";
		String packageName = FileUtil.createPackageNameFromTargetNamespace(tns);
		return packageName + "." + className;
	}


	public File generate(String basedir) throws IOException {
		String className = serviceClassName + "_Main";
		String packageName = FileUtil.createPackageNameFromTargetNamespace(tns);
		this.clazz = packageName + "." + className;

		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}
		File f = FileUtil.createFile(className, packageName, basedir, ".java", true);
		//	File f = new File(basedir + "/" + packageName.replace(".", "/") + "/"+ className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// create imports
			writer.write("import javax.xml.ws.Endpoint;\n");
			writer.write("import java.io.File;\n");
			writer.write("import java.io.InputStream;\n");
			writer.write("import java.io.FileInputStream;\n");
			writer.write("import java.util.logging.LogManager;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
			writer.write("import org.petalslink.abslayer.service.api.Description;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
			writer.write("\n");

			// create class
			writer.write("public class " + className + " {\n");
			writer.write("\n");

			writer.write("private final static String LOGGER_FILE = \"/logger.properties\";\n");

			writer.write("\tstatic {\n");
			writer.write("\ttry {\n");
			writer.write("\t		InputStream inputStream = null;\n");
			writer.write("\t		File logger = new File(\".\" + LOGGER_FILE);\n");
			writer.write("\t		if (logger.exists()) {\n");
			writer.write("\t			inputStream = new FileInputStream(logger);\n");
			writer.write("\t		} else {\n");
			writer.write("\t			// ty to get from classpath\n");
			writer.write("\t			inputStream = " + className + ".class.getClass()\n");
			writer.write("\t					.getResourceAsStream(LOGGER_FILE);\n");
			writer.write("\t		}\n");
			writer.write("\t		if (inputStream != null) {\n");
			writer.write("\t			LogManager.getLogManager().readConfiguration(inputStream);\n");
			writer.write("\t			inputStream.close();\n");
			writer.write("\t		}\n");
			writer.write("\t	} catch (final Exception e) {\n");
			writer.write("\t		throw new RuntimeException(\"couldn't initialize logging properly\",\n");
			writer.write("\t				e);\n");
			writer.write("\t	}\n");
			writer.write("\t}\n");
			writer.write("\t\n");

			// create constructor
			writer.write("\tpublic " + className + "() {\n");
			writer.write("\t}\n");
			writer.write("\n\n");

	
			// create main methods
			writer.write("\tpublic static void main(String args[]) throws Exception {\n");
			
			for(String server: this.allServerNamesInDef) {
				writer.write(server + ".main(args);\n");
			}

			writer.write("\n");
			writer.write("}\n");
			writer.write("}\n");
		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}


	public String getClassName() {
		return clazz;
	}

}
