package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map.Entry;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Annotation;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class ServiceGenerator {

	private ImplMetaInf imf;
	private String tns; 

	public ServiceGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
		this.imf = imf;
		this.tns = tns;
	}

	public File generate(String basedir) throws IOException {
		String className = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
		className = className + "_WSOUIService";
		
		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.tns);
		
		File f = new File(basedir + "/" + packageName.replace(".", "/") + "/" + className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// add import
			writer.write("import " + imf.getSignaturePackage() + "." + imf.getInterfaceName() + ";\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIService;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
			writer.write("import java.net.URL;\n");
			writer.write("import javax.xml.namespace.QName;\n");
			writer.write("import javax.xml.ws.WebEndpoint;\n");
			writer.write("import javax.xml.ws.WebServiceClient;\n");
			writer.write("import javax.xml.ws.WebServiceFeature;\n");
			writer.write("import javax.xml.ws.Service;\n");

			writer.write("\n");

			// create annotations class
//			String targetNamespace = "";
//			String serviceName = "";
//			String endpointName = "";
//			String endpointNameVariable = "";
			for(Annotation a: imf.getAnnotationClass()) {
				String annotation = "";
				annotation = "@WebServiceClient" + "(\n";
				for(Entry<String, String> entry: a.getFields().entrySet()) {
					if(entry.getKey().equals("serviceName")) {
						annotation = annotation + "\t" + "name" + " = \"" + imf.getServiceName() + "\",\n";
					} else if(entry.getKey().equals("wsdlLocation")) {
						annotation = annotation + "\t" + entry.getKey() + " = \"" + imf.getWsdlLocation() + "\",\n";
					} else if(entry.getKey().equals("targetNamespace")) {
						annotation = annotation + "\t" + entry.getKey() + " = \"" + imf.getTargetNamespace() + "\",\n";
					} 
				}
				annotation = annotation.substring(0, annotation.length() - ",\n".length()) + ")\n";
				writer.write(annotation);
			}
			String endpointNameVariable = imf.getEndpointName().substring(0, 1).toUpperCase() + imf.getEndpointName().substring(1);


			// create class
			writer.write("public class " + className + " extends Service implements " + "WSOUIService" + "{\n");
			writer.write("\n");
			
			// create variable
		    writer.write("\tprivate static URL WSDL_LOCATION;\n");
		    writer.write("\tpublic final static QName SERVICE = new QName(\"" + imf.getTargetNamespace() + "\", \"" + imf.getServiceName() + "\");\n");
		    writer.write("\tpublic final static QName " + endpointNameVariable + " = new QName(\"" + imf.getTargetNamespace() + "\", \"" + imf.getServiceName() + "\");\n");
		    writer.write("\t\n");
		    writer.write("\tpublic static URL getWSDL_LOCATION() {\n");
		    writer.write("\t  if(WSDL_LOCATION == null) {\n");
		    writer.write("\t    WSDL_LOCATION = Thread.currentThread().getContextClassLoader().getResource(\"" + imf.getWsdlLocation().replace("./", "") + "\");\n");
		    writer.write("\t    if(WSDL_LOCATION == null) {\n");
		    writer.write("\t       throw new RuntimeException(\"Impossible to find wsdl in class loader at: " + imf.getWsdlLocation().replace("./", "") + "\");\n");
		    writer.write("\t    } else {\n");
		    writer.write("\t       System.out.println(\"WSDL localized at: \" + WSDL_LOCATION + \"\");\n");
		    writer.write("\t    }\n");
		    writer.write("\t  }\n");
		    writer.write("\t  return WSDL_LOCATION;\n");
		    writer.write("\t}\n");

			// create constructor
			writer.write("\tpublic " + className + "() {\n");
			writer.write("\t\tsuper(getWSDL_LOCATION(), SERVICE);\n");
			writer.write("\t}\n");
			writer.write("\n");

			
			// create all methods
			writer.write("\t@WebEndpoint(name = \"" + imf.getEndpointName() + "\")\n");
			writer.write("\tpublic " + imf.getInterfaceName() + " get" + endpointNameVariable + "() {\n");
			writer.write("\t    return super.getPort(" + endpointNameVariable + ", " + imf.getInterfaceName() + ".class);\n");
			writer.write("\t}\n");
			writer.write("\t\n");
			writer.write("\t\n");

			writer.write("\t@WebEndpoint(name = \"" + imf.getEndpointName() + "\")\n");
			writer.write("\tpublic " + imf.getInterfaceName() + " getFiremenSOAP(WebServiceFeature... features) {\n");
			writer.write("\t    return super.getPort(" + endpointNameVariable + ", " + imf.getInterfaceName() + ".class, features);\n");
			writer.write("\t}\n");
			writer.write("\t\n");
			writer.write("\t\n");

			writer.write("\tpublic URL getWsdlLocation() {\n");
			writer.write("\t    return WSDL_LOCATION;\n");
			writer.write("\t}\n");
		    
			writer.write("\n");
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
