package org.petalslink.easiestdemo.wsoui.provided;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.impl.WSOUIModelObjectComparator;



public class AbstractExchangeProcessor {

	private Map<String, List<Exchange>> expectedExchanges = new HashMap<String, List<Exchange>>();


	public AbstractExchangeProcessor() {

	}

	public Exchange<?, ?, ?> match(String operation, Object currentRequest) {
		Exchange<?, ?, ?> expectedExchange = null;
		for(Exchange ex: this.getExpectedExchangesForOperation(operation)) {
			if(ex.getExpectedRequest() instanceof ModelObject && currentRequest instanceof ModelObject) {
				if(WSOUIModelObjectComparator.areEquals((ModelObject)ex.getExpectedRequest(), (ModelObject)currentRequest)) {
					expectedExchange = ex;
					break;
				}
			} else {
				if(ex.getExpectedRequest().equals(currentRequest)) {
					expectedExchange = ex;
					break;
				}
			}
		}
		return expectedExchange;
	}

	public List<Exchange> getExpectedExchangesForOperation(String name) {
		return expectedExchanges.get(name);
	}

	protected void addExpectedExchange(String op, Exchange ex) {
		List<Exchange> exchanges = this.expectedExchanges.get(op);
		if(exchanges == null) {
			exchanges = new ArrayList<Exchange>();
		}
		exchanges.add(ex);
		this.expectedExchanges.put(op, exchanges);
	}
}
