package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class EventProducerNotifierGenerator {

    private String topicSet;
    
    private String topicNamespace;

    private ImplMetaInf imf;

    private boolean override = false;

    private String tns;

    public EventProducerNotifierGenerator(String tns, ImplMetaInf imf, String topicSet, String topicnamespace, boolean override) throws WSOUIException {
        this.imf = imf;
        this.override = override;
        this.tns = tns;
        this.topicSet = topicSet;
        this.topicNamespace = topicnamespace;
    }






    public File generate(String basedir) throws IOException {
        String className = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
        className = className + "_EventProducerNotifier";

        String packageName = FileUtil.createPackageNameFromTargetNamespace(this.tns);

        File dir = new File(basedir + "/" + packageName.replace(".", "/"));
        if(!dir.exists()) {
            dir.mkdirs();
        }

        File f = FileUtil.createFile(className, packageName, basedir, ".java", this.override);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);

            // create package
            writer.write("package " + packageName + ";\n");
            writer.write("\n");

            // create imports
            for(String impt: imf.getImports()) {
                writer.write("import " + impt + ";\n");
            }
            // add specific import
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;\n");
            writer.write("import java.net.URL;\n");
            writer.write("import java.net.MalformedURLException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");
            writer.write("import org.petalslink.easiestdemo.wsoui.provided.notification.SubscriptionManager;\n");

            writer.write("\n");


            // create class
            writer.write("public class " + className + " extends AbstractEventProducerNotifier {\n");
            writer.write("\n");

            // create constructor
            writer.write("\tpublic " + className + "(ProviderConfiguration configuration, WSOUIJaxbContextItf context) throws WSOUIException {\n");
            writer.write("\t\tsuper(configuration, context);\n");

            if(this.topicSet != null) {
                writer.write("\t\tthis.getSubscriptionManager().setTopicSet(Thread.currentThread().getContextClassLoader().getResource(\"" + this.topicSet + "\"));\n");
            }
            
            if(this.topicNamespace != null) {
                writer.write("\t\tthis.getSubscriptionManager().setTopicNamespace(Thread.currentThread().getContextClassLoader().getResource(\"" + this.topicNamespace + "\"));\n");
            }


            writer.write("\t}\n");
            writer.write("\n");

            // create all methods
            writer.write("\t@Override\n");
            writer.write("\tpublic void setPeriodEvent() {\n");
            writer.write("\t\tthis.setPeriodEvent(0); // Set the period to send event (in ms).\n");
            writer.write("\t}\n");
            writer.write("\n\n");


            writer.write("\t@Override\n");
            writer.write("\tpublic Object createPeriodicallyEvent() throws WSOUIException {\n");
            writer.write("\t\tObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");

            writer.write("\t@Override\n");
            writer.write("\tpublic Object createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException {\n");
            writer.write("\t\tObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");

            writer.write("\t@Override\n");
            writer.write("\tpublic Object createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException {\n");
            writer.write("\t\tObject event = null; // TODO: create Event.\n");
            writer.write("\t\treturn event;\n");
            writer.write("\t}\n");
            writer.write("\n\n");


            writer.write("\n");
            writer.write("}\n");



        } finally{
            if(writer != null){
                writer.close();
            }
        }

        return f;
    }

}
