/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.plugin.wsdl;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easysawsdl10.api.SawsdlHelper;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.cxf.tools.wsdlto.core.PluginLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.wsdl.EventProducerNotifierGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.ExchangeProcessorGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.ImplementationManagerGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.ServerGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.ServerMain;
import org.petalslink.easiestdemo.wsoui.core.wsdl.ServiceGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.TestImplementationGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.WSDLJUnitTestGenerator;
import org.petalslink.easiestdemo.wsoui.core.wsdl.WSOUIJaxbContextGenerator;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.Provider;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.WSOUIBindingGenerator;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.WsdlOption;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;

public class WSDL2JavaGenerateSourcesMojo
extends AbstractMojo {
    static Logger LOG = Logger.getLogger(WSDL2JavaGenerateSourcesMojo.class.getName());
    public static String IMAGE_METADATA_PATH = "http://www.petalslink.org/wsoui/image";
    public static String POSITION_METADATA_PATH = "http://www.petalslink.org/wsoui/position";
    public static String TOPICSET_METADATA_PATH = "http://www.petalslink.org/wsoui/topicset";
    public static String TOPICNAMESPACE_METADATA_PATH = "http://www.petalslink.org/wsoui/topicnamespace";
    List<String> resourcesRootList = Arrays.asList("/src/main/resources", "src/test/resources");
    String sourceRoot = "/src/main/java";
    String testsourceRoot = "/src/test/java";
    String generatedTestSourceRoot = "/target/generated-test-sources/wsoui";
    String generatedSourceRoot = "/target/generated-sources/wsoui";
    URI basedir = new File(".").toURI();
    MavenProject project;
    WsdlOption[] wsdlOptions;
    boolean activeGUI = false;
    private List<String> allServerMain = new ArrayList<String>();
    private List<String> allWSOUIServer = new ArrayList<String>();
    private List<ImplMetaInf> allMetainfs = new ArrayList<ImplMetaInf>();
    File sourceRootFile = null;
    File testsourceRootFile = null;
    File generatedTestSourceRootFile = null;
    File generatedSourceRootFile = null;
    private boolean compileClass = true;

    public void execute() throws MojoExecutionException {
        List<WsdlOption> effectiveWsdlOptions = Arrays.asList(this.wsdlOptions);
        if (effectiveWsdlOptions.size() == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        if (this.project != null) {
            this.basedir = this.project.getBasedir().toURI();
            this.sourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.sourceRoot));
            this.testsourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.testsourceRoot));
            this.generatedTestSourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.generatedTestSourceRoot));
            this.generatedSourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)this.generatedSourceRoot));
        } else {
            this.sourceRootFile = new File(URI.create(this.basedir.toString() + this.sourceRoot));
            this.testsourceRootFile = new File(URI.create(this.basedir.toString() + this.testsourceRoot));
            this.generatedTestSourceRootFile = new File(URI.create(this.basedir.toString() + this.generatedTestSourceRoot));
            this.generatedSourceRootFile = new File(URI.create(this.basedir.toString() + this.generatedSourceRoot));
        }
        try {
            ArrayList<Provider> providers = new ArrayList<Provider>();
            for (WsdlOption o : effectiveWsdlOptions) {
                Definitions definitions = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(FileUtil.getURI((URI)this.basedir, (String)o.getWsdl()).toURL(), Definitions.class);
                ArrayList<String> allServerNamesInDef = new ArrayList<String>();
                if (definitions.getServices().length > 0) {
                    for (Service s : definitions.getServices()) {
                        providers.add(this.createProviderFromService(s));
                    }
                    QName eventProducerItfQName = new QName("http://www.petalslink.com/wsn/service/WsnProducer", "NotificationProducer");
                    URI itf = this.findInterface(definitions, eventProducerItfQName);
                    o.setRelatifEventImport(itf);
                    o.setSchemaLocationOfWsAddressing(this.findSchemaLocationImportFromNamespace(definitions, "http://www.w3.org/2005/08/addressing"));
                    this.callWsdl2Java(o);
                    try {
                        Provider correspondingProvider;
                        ArrayList<File> implementations = new ArrayList<File>();
                        implementations.addAll(this.findImplementationFile(this.generatedSourceRootFile));
                        implementations.addAll(this.findImplementationFile(this.generatedTestSourceRootFile));
                        ArrayList<ImplMetaInf> metainfs = new ArrayList<ImplMetaInf>();
                        for (File f : implementations) {
                            metainfs.add(new ImplMetaInf(f, new File(FileUtil.getURI((URI)this.basedir, (String)o.getWsdl()))));
                        }
                        for (ImplMetaInf imf : metainfs) {
                            if (!imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                            ImplementationManagerGenerator img = new ImplementationManagerGenerator(definitions.getTargetNamespace(), imf);
                            img.generate(this.generatedSourceRootFile.toString());
                        }
                        for (ImplMetaInf imf : metainfs) {
                            if (!imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                            TestImplementationGenerator timg = new TestImplementationGenerator(definitions.getTargetNamespace(), imf);
                            timg.generate(this.generatedSourceRootFile.toString());
                        }
                        for (ImplMetaInf imf : metainfs) {
                            if (!imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                            ServiceGenerator sg = new ServiceGenerator(definitions.getTargetNamespace(), imf);
                            sg.generate(this.generatedSourceRootFile.toString());
                        }
                        for (ImplMetaInf imf : metainfs) {
                            if (!imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                            WSDLJUnitTestGenerator wjutg = new WSDLJUnitTestGenerator(definitions.getTargetNamespace(), imf);
                            wjutg.generate(this.testsourceRootFile.toString());
                        }
                        if (o.isGenerateBusinessClass()) {
                            for (ImplMetaInf imf : metainfs) {
                                if (!imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                                ExchangeProcessorGenerator epg = new ExchangeProcessorGenerator(definitions.getTargetNamespace(), imf, o.isOverrideOlderBusinessClass());
                                epg.generate(this.sourceRootFile.toString());
                            }
                            if (o.getProvider()) {
                                for (ImplMetaInf imf : metainfs) {
                                    correspondingProvider = this.findProviderCorrespondingToImpl(providers, imf);
                                    if (correspondingProvider == null || !imf.getTargetNamespace().equals(definitions.getTargetNamespace())) continue;
                                    EventProducerNotifierGenerator evg = new EventProducerNotifierGenerator(definitions.getTargetNamespace(), imf, correspondingProvider.getTopicSet(), correspondingProvider.getTopicNameSpace(), o.isOverrideOlderBusinessClass());
                                    evg.generate(this.sourceRootFile.toString());
                                    ServerGenerator sg = new ServerGenerator(definitions.getTargetNamespace(), imf, correspondingProvider, this.activeGUI, o.isOverrideOlderBusinessClass());
                                    sg.generate(this.sourceRootFile.toString());
                                    if (allServerNamesInDef.contains(sg.getClassName())) continue;
                                    allServerNamesInDef.add(sg.getClassName());
                                }
                            }
                        } else {
                            for (ImplMetaInf imf : metainfs) {
                                ServerGenerator sg;
                                correspondingProvider = this.findProviderCorrespondingToImpl(providers, imf);
                                if (correspondingProvider == null || !imf.getTargetNamespace().equals(definitions.getTargetNamespace()) || allServerNamesInDef.contains((sg = new ServerGenerator(definitions.getTargetNamespace(), imf, correspondingProvider, this.activeGUI, o.isOverrideOlderBusinessClass())).deduceClassName(this.sourceRootFile.toString()))) continue;
                                allServerNamesInDef.add(sg.deduceClassName(this.sourceRootFile.toString()));
                            }
                        }
                        ArrayList<File> oldFiles = new ArrayList<File>();
                        oldFiles.addAll(implementations);
                        oldFiles.addAll(this.findServiceFile(this.generatedSourceRootFile));
                        oldFiles.addAll(this.findServiceFile(this.generatedTestSourceRootFile));
                        oldFiles.addAll(this.findServerFile(this.generatedSourceRootFile));
                        oldFiles.addAll(this.findServerFile(this.generatedTestSourceRootFile));
                        for (File impl : oldFiles) {
                            impl.delete();
                        }
                        FileUtil.deleteDirectory((File)new File(URIHelper.resolve((URI)this.generatedSourceRootFile.toURI(), (String)"com/ebmwebsourcing/wsstar/jaxb")));
                        FileUtil.deleteDirectory((File)new File(URIHelper.resolve((URI)this.generatedSourceRootFile.toURI(), (String)"easybox/org/w3/_2005/_08/addressing")));
                        this.allMetainfs.addAll(metainfs);
                    }
                    catch (WSOUIException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                    catch (URISyntaxException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                LOG.warning("this definitions contains no services: " + o.getWsdl());
                if (definitions != null && definitions.getName() != null && !definitions.getName().equals("WsnProducer") && definitions.getServices().length > 0) {
                    ServerMain serverMain = new ServerMain(definitions.getTargetNamespace(), definitions.getName(), allServerNamesInDef, o.isOverrideOlderBusinessClass());
                    serverMain.generate(this.generatedSourceRootFile.toString());
                    if (!this.allServerMain.contains(serverMain.getClassName())) {
                        this.allServerMain.add(serverMain.getClassName());
                    }
                }
                this.allWSOUIServer.addAll(allServerNamesInDef);
            }
            ArrayList<File> objectFactories = new ArrayList<File>();
            objectFactories.addAll(this.findObjectFactoryFile(this.generatedSourceRootFile));
            WSOUIJaxbContextGenerator wjcg = new WSOUIJaxbContextGenerator(objectFactories);
            try {
                wjcg.generate(this.generatedSourceRootFile.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (Provider p1 : providers) {
                String port = this.getPort(p1.getEndpointAddress());
                for (Provider p2 : providers) {
                    if (p1 == p2 || !port.equals(this.getPort(p2.getEndpointAddress()))) continue;
                    throw new MojoExecutionException("CXF Implementation restriction: 2 endpoints must not have the same port: " + p1.getEndpointAddress() + " and " + p2.getEndpointAddress());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XmlObjectReadException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (WSOUIException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            Bus bus = BusFactory.getDefaultBus((boolean)false);
            if (bus != null) {
                bus.shutdown(true);
            }
            PluginLoader.unload();
        }
        if (this.isCompileClass()) {
            if (this.project != null && this.generatedSourceRootFile != null && this.generatedSourceRootFile.exists()) {
                this.project.addCompileSourceRoot(this.generatedSourceRootFile.getAbsolutePath());
            }
            if (this.project != null && this.generatedTestSourceRootFile != null && this.generatedTestSourceRootFile.exists()) {
                this.project.addTestCompileSourceRoot(this.generatedTestSourceRootFile.getAbsolutePath());
            }
            System.gc();
        }
    }

    private URI findInterface(Definitions definitions, QName eventProducerItfQName) {
        PortType res = definitions.getPortTypeByName(eventProducerItfQName.getLocalPart());
        if (definitions.getTargetNamespace().trim().toString().equals(eventProducerItfQName.getNamespaceURI().trim().toString()) && res != null) {
            return res.getXmlObjectBaseURI();
        }
        int i$ = 0;
        Import[] arr$ = definitions.getImports();
        int len$ = arr$.length;
        if (i$ < len$) {
            Import impt = arr$[i$];
            return this.findInterface((Definitions)impt.getXmlObjectAdoptedChildren()[0], eventProducerItfQName);
        }
        return null;
    }

    private URI findSchemaLocationImportFromNamespace(Definitions definitions, String ns) throws MalformedURLException, URISyntaxException {
        URI res = null;
        if (definitions.getTypes() != null) {
            for (XmlObject obj : definitions.getTypes().getAnyXmlObjects()) {
                if (obj instanceof Schema) {
                    Schema s = (Schema)obj;
                    res = this.findSchemaLocationImportFromNamespace(s, ns);
                    continue;
                }
                if (!(obj instanceof com.ebmwebsourcing.easyschema10.api.element.Import)) continue;
                com.ebmwebsourcing.easyschema10.api.element.Import impt = (com.ebmwebsourcing.easyschema10.api.element.Import)obj;
                if (impt.getNamespace().equals(ns)) {
                    return URIHelper.resolve((URI)impt.getXmlObjectBaseURI(), (String)impt.getSchemaLocation());
                }
                res = this.findSchemaLocationImportFromNamespace((Schema)impt.getXmlObjectAdoptedChildren()[0], ns);
                if (res != null) break;
            }
        }
        if (res == null) {
            XmlObject impt;
            XmlObject[] arr$ = definitions.getImports();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (res = this.findSchemaLocationImportFromNamespace((Definitions)(impt = arr$[i$]).getXmlObjectAdoptedChildren()[0], ns)) == null; ++i$) {
            }
        }
        return res;
    }

    private URI findSchemaLocationImportFromNamespace(Schema schema, String ns) throws MalformedURLException, URISyntaxException {
        URI res = null;
        for (com.ebmwebsourcing.easyschema10.api.element.Import impt : schema.getImports()) {
            if (impt.getNamespace().equals(ns)) {
                return URIHelper.resolve((URI)impt.getXmlObjectBaseURI(), (String)impt.getSchemaLocation());
            }
            res = this.findSchemaLocationImportFromNamespace((Schema)impt.getXmlObjectAdoptedChildren()[0], ns);
            if (res != null) break;
        }
        return res;
    }

    private Provider findProviderCorrespondingToImpl(List<Provider> providers, ImplMetaInf imf) {
        Provider res = null;
        for (Provider p : providers) {
            if (!imf.getServiceName().equals(p.getServiceQName().getLocalPart())) continue;
            res = p;
            break;
        }
        return res;
    }

    private String getPort(String endpointAddress) {
        String port = "80";
        if (endpointAddress != null && endpointAddress.contains(":")) {
            port = endpointAddress.replace("http://", "");
            port = port.substring(port.indexOf(":") + 1, port.length());
            port = port.substring(0, port.indexOf("/"));
        }
        return port;
    }

    private Provider createProviderFromService(Service service) throws WSOUIException {
        Provider res = new Provider();
        List<URI> uris = Arrays.asList(SawsdlHelper.getModelReference((XmlObject)service));
        String image = this.findImage(uris);
        String topicset = this.findTopicSet(uris);
        String topicnamespace = this.findTopicNamespace(uris);
        ProviderConfiguration.PositionType pos = this.findPosition(uris);
        if (image != null) {
            res.setImage(image.toString());
        }
        if (pos != null) {
            res.setPosition(pos);
        }
        if (topicset != null) {
            res.setTopicSet(topicset);
        }
        if (topicnamespace != null) {
            res.setTopicNameSpace(topicnamespace);
        }
        if (service.getPorts().length != 1) {
            throw new WSOUIException("EasiestDemo Restriction: Each service must contain only one endpoint");
        }
        res.setServiceQName(service.inferQName());
        Address address = SoapBindingHelper.getAddress((Port)service.getPorts()[0]);
        if (address == null) {
            throw new WSOUIException("Impossible to find endpoint address: " + service.getPorts()[0].getName());
        }
        res.setEndpointAddress(address.getLocation());
        return res;
    }

    private ProviderConfiguration.PositionType findPosition(List<URI> uris) {
        ProviderConfiguration.PositionType res = null;
        for (URI uri : uris) {
            if (!uri.toString().startsWith(POSITION_METADATA_PATH)) continue;
            String position = uri.toString().replace(POSITION_METADATA_PATH + "#", "");
            res = ProviderConfiguration.PositionType.getPositionTypeFromString(position);
            break;
        }
        return res;
    }

    private String findImage(List<URI> uris) throws WSOUIException {
        String res = null;
        try {
            for (URI uri : uris) {
                if (!uri.toString().startsWith(IMAGE_METADATA_PATH)) continue;
                String imagePath = uri.toString().replace(IMAGE_METADATA_PATH + "#", "");
                if (imagePath.startsWith("classpath://")) {
                    res = imagePath.replace("classpath://", "");
                    URL url = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (url == null) {
                        for (String resourcesDir : this.resourcesRootList) {
                            File resourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)resourcesDir));
                            String resource = resourceRootFile + "/" + res;
                            url = new File(resource).toURI().toURL();
                        }
                    }
                    if (url == null) {
                        throw new WSOUIException("Impossible to find resource image: " + res);
                    }
                } else {
                    res = imagePath;
                }
                break;
            }
        }
        catch (MalformedURLException e) {
            throw new WSOUIException(e);
        }
        return res;
    }

    private String findTopicSet(List<URI> uris) throws WSOUIException {
        String res = null;
        try {
            for (URI uri : uris) {
                if (!uri.toString().startsWith(TOPICSET_METADATA_PATH)) continue;
                String topicSetPath = uri.toString().replace(TOPICSET_METADATA_PATH + "#", "");
                if (topicSetPath.startsWith("classpath://")) {
                    res = topicSetPath.replace("classpath://", "");
                    URL url = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (url == null) {
                        for (String resourcesDir : this.resourcesRootList) {
                            File resourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)resourcesDir));
                            String resource = resourceRootFile + "/" + res;
                            url = new File(resource).toURI().toURL();
                        }
                    }
                    if (url == null) {
                        throw new WSOUIException("Impossible to find resource image: " + res);
                    }
                } else {
                    res = topicSetPath;
                }
                break;
            }
        }
        catch (MalformedURLException e) {
            throw new WSOUIException(e);
        }
        return res;
    }

    private String findTopicNamespace(List<URI> uris) throws WSOUIException {
        String res = null;
        try {
            for (URI uri : uris) {
                if (!uri.toString().startsWith(TOPICNAMESPACE_METADATA_PATH)) continue;
                String topicNsPath = uri.toString().replace(TOPICNAMESPACE_METADATA_PATH + "#", "");
                if (topicNsPath.startsWith("classpath://")) {
                    res = topicNsPath.replace("classpath://", "");
                    URL url = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (url == null) {
                        for (String resourcesDir : this.resourcesRootList) {
                            File resourceRootFile = new File(FileUtil.getURI((URI)this.basedir, (String)resourcesDir));
                            String resource = resourceRootFile + "/" + res;
                            url = new File(resource).toURI().toURL();
                        }
                    }
                    if (url == null) {
                        throw new WSOUIException("Impossible to find resource image: " + res);
                    }
                } else {
                    res = topicNsPath;
                }
                break;
            }
        }
        catch (MalformedURLException e) {
            throw new WSOUIException(e);
        }
        return res;
    }

    private Collection<? extends File> findImplementationFile(File dir) {
        ArrayList<? extends File> res = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                res.addAll(this.findImplementationFile(f));
            }
        } else if (dir.toString().endsWith("Impl.java")) {
            res.add(dir);
        }
        return res;
    }

    private Collection<? extends File> findServiceFile(File dir) {
        ArrayList<? extends File> res = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                res.addAll(this.findServiceFile(f));
            }
        } else if (dir.toString().endsWith("_Service.java")) {
            res.add(dir);
        }
        return res;
    }

    private Collection<? extends File> findObjectFactoryFile(File dir) {
        ArrayList<? extends File> res = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                res.addAll(this.findObjectFactoryFile(f));
            }
        } else if (dir.toString().endsWith("ObjectFactory.java")) {
            res.add(dir);
        }
        return res;
    }

    private Collection<? extends File> findServerFile(File dir) {
        ArrayList<? extends File> res = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                res.addAll(this.findServerFile(f));
            }
        } else if (dir.toString().endsWith("_Server.java")) {
            res.add(dir);
        }
        return res;
    }

    private void callWsdl2Java(WsdlOption wsdlOption) throws MojoExecutionException {
        File outputDirFile = this.generatedSourceRootFile;
        outputDirFile.mkdirs();
        try {
            WSOUIBindingGenerator gen = new WSOUIBindingGenerator(wsdlOption);
            List<String> list = wsdlOption.generateCommandLine(this.basedir, outputDirFile.toString());
            Object[] args = list.toArray(new String[list.size()]);
            this.getLog().info((CharSequence)("Calling wsdl2java with args: " + Arrays.toString(args)));
            System.out.println("Calling wsdl2java with args: " + Arrays.toString(args));
            new WSDLToJava((String[])args).run(new ToolContext());
        }
        catch (Throwable e) {
            this.getLog().debug(e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public WsdlOption[] getWsdlOptions() {
        return this.wsdlOptions;
    }

    public void setWsdlOptions(WsdlOption[] wsdlOptions) {
        this.wsdlOptions = wsdlOptions;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public String getTestsourceRoot() {
        return this.testsourceRoot;
    }

    public void setTestsourceRoot(String testsourceRoot) {
        this.testsourceRoot = testsourceRoot;
    }

    public String getGeneratedTestSourceRoot() {
        return this.generatedTestSourceRoot;
    }

    public void setGeneratedTestSourceRoot(String generatedTestSourceRoot) {
        this.generatedTestSourceRoot = generatedTestSourceRoot;
    }

    public String getGeneratedSourceRoot() {
        return this.generatedSourceRoot;
    }

    public void setGeneratedSourceRoot(String generatedSourceRoot) {
        this.generatedSourceRoot = generatedSourceRoot;
    }

    public boolean isActiveGUI() {
        return this.activeGUI;
    }

    public void setActiveGUI(boolean activeGUI) {
        this.activeGUI = activeGUI;
    }

    public List<String> getAllServerMain() {
        return this.allServerMain;
    }

    public List<String> getAllWSOUIServer() {
        return this.allWSOUIServer;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isCompileClass() {
        return this.compileClass;
    }

    public void setCompileClass(boolean compileClass) {
        this.compileClass = compileClass;
    }

    public List<ImplMetaInf> getAllMetainfs() {
        return this.allMetainfs;
    }
}

