/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.plugin.wsdl;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.plugin.wsdl.WSOUIBindingGenerator;

public class WsdlOption {
    String wsdl;
    boolean provider = true;
    boolean generateBusinessClass = true;
    boolean overrideOlderBusinessClass = false;
    private URI relatifEventImport;
    private URI schemaLocationOfWsAddressing;

    public URI getRelatifEventImport() {
        return this.relatifEventImport;
    }

    public void setRelatifEventImport(URI relatifEventImport) {
        this.relatifEventImport = relatifEventImport;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String w) {
        this.wsdl = w;
    }

    public boolean getProvider() {
        return this.provider;
    }

    public void setProvider(boolean provider) {
        this.provider = provider;
    }

    public List<String> generateCommandLine(URI basedir, String generatedSource) throws WSOUIException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (generatedSource != null) {
                list.add("-d");
                list.add(generatedSource);
            }
            WSOUIBindingGenerator gen = new WSOUIBindingGenerator(this);
            for (URI b : gen.generateBindings(this.getWsdl(), basedir)) {
                list.add("-b");
                list.add(b.toString());
            }
            if (this.provider) {
                list.add("-server");
            }
            if (this.provider) {
                list.add("-impl");
            }
            list.add("-noAddressBinding");
            list.add("-dns");
            list.add("false");
            list.add(FileUtil.getURI((URI)basedir, (String)this.getWsdl()).toString());
        }
        catch (IOException e) {
            throw new WSOUIException(e);
        }
        catch (URISyntaxException e) {
            throw new WSOUIException(e);
        }
        return list;
    }

    public String toString() {
        return "WsdlOption [wsdl=" + this.wsdl + ", provider=" + this.provider + ", generateBusinessClass=" + this.generateBusinessClass + ", overrideOlderBusinessClass=" + this.overrideOlderBusinessClass + "]";
    }

    public boolean isGenerateBusinessClass() {
        return this.generateBusinessClass;
    }

    public void setGenerateBusinessClass(boolean generateBusinessClass) {
        this.generateBusinessClass = generateBusinessClass;
    }

    public boolean isOverrideOlderBusinessClass() {
        return this.overrideOlderBusinessClass;
    }

    public void setOverrideOlderBusinessClass(boolean overrideOlderBusinessClass) {
        this.overrideOlderBusinessClass = overrideOlderBusinessClass;
    }

    public void setSchemaLocationOfWsAddressing(URI findSchemaLocationImportFromNamespace) {
        this.schemaLocationOfWsAddressing = findSchemaLocationImportFromNamespace;
    }

    public URI getSchemaLocationOfWsAddressing() {
        return this.schemaLocationOfWsAddressing;
    }
}

