/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELAnalyser;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easysawsdl10.api.SawsdlHelper;
import com.ebmwebsourcing.easyschema10.api.element.Include;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.petalslink.easiestdemo.sdk.SDKException;
import org.petalslink.easiestdemo.sdk.ThreadRun;
import org.petalslink.easiestdemo.sdk.core.BPELGenerator;
import org.petalslink.easiestdemo.sdk.core.POMGenerator;
import org.petalslink.easiestdemo.sdk.core.WSDLGenerator;
import org.petalslink.easiestdemo.sdk.util.FileUtil;
import org.petalslink.easiestdemo.sdk.util.OSValidator;

public class SDKService {
    public static String IMAGE_METADATA_PATH = "http://www.petalslink.org/wsoui/image";
    private String scriptPath = ".";
    private Logger log = Logger.getLogger(this.getClass().getName());

    public QName createNewProject(String tns, String bpelProcessName, File targetDirectory, boolean generateFile) throws SDKException {
        QName res = null;
        try {
            String groupId = FileUtil.createPackageNameFromTargetNamespace(tns.toLowerCase());
            String artifactId = bpelProcessName.toLowerCase();
            File projectDirectory = new File(targetDirectory.toString() + "/" + artifactId);
            projectDirectory.mkdirs();
            File srcMainJavaDirectory = new File(projectDirectory.toString() + "/src/main/java");
            File srcMainResourcesDirectory = new File(projectDirectory.toString() + "/src/main/resources");
            File srcTestJavaDirectory = new File(projectDirectory.toString() + "/src/test/java");
            File srcTesResourcesDirectory = new File(projectDirectory.toString() + "/src/test/resources");
            srcMainJavaDirectory.mkdirs();
            srcMainResourcesDirectory.mkdirs();
            srcTestJavaDirectory.mkdirs();
            srcTesResourcesDirectory.mkdirs();
            POMGenerator pgen = new POMGenerator(groupId, artifactId, "1.0-SNAPSHOT", bpelProcessName);
            pgen.generate(targetDirectory.toString(), artifactId);
            if (generateFile) {
                BPELGenerator bpelgen = new BPELGenerator(tns, bpelProcessName);
                bpelgen.generate(srcMainResourcesDirectory.toString(), bpelProcessName + ".bpel");
                WSDLGenerator wsdlgen = new WSDLGenerator(tns, bpelProcessName);
                wsdlgen.generate(srcMainResourcesDirectory.toString(), bpelProcessName + ".wsdl");
            }
            res = new QName(tns, bpelProcessName);
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        return res;
    }

    public QName createProjectFromBpel(URL bpel, File targetDirectory) throws SDKException {
        QName res = null;
        try {
            ArrayList<URI> allimpturis = new ArrayList<URI>();
            BPELValidator validator = new BPELValidator();
            ValidatorResult result = validator.validate(bpel);
            BPELAnalyser analyzer = new BPELAnalyser();
            AnalysorResult analyzerResult = analyzer.analyze(result.getProcess());
            for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import bpelimpt : result.getProcess().getImports().getBPELImports()) {
                if (bpelimpt.getDescription() != null) {
                    Definitions def = (Definitions)bpelimpt.getDescription().getModel();
                    allimpturis.addAll(this.getAllURIsInDescription(bpel, def));
                    if (!allimpturis.contains(URIHelper.resolve((URI)bpel.toURI(), (String)bpelimpt.getLocation().toString()))) {
                        allimpturis.add(URIHelper.resolve((URI)bpel.toURI(), (String)bpelimpt.getLocation().toString()));
                    }
                    for (Service s : def.getServices()) {
                        List<URI> uris = Arrays.asList(SawsdlHelper.getModelReference((XmlObject)s));
                        String image = this.findImage(uris);
                        System.out.println("Image = " + image);
                        if (image == null) continue;
                        allimpturis.add(URIHelper.resolve((URI)bpel.toURI(), (String)image));
                    }
                    continue;
                }
                if (bpelimpt.getSchema2() == null) continue;
                allimpturis.addAll(this.getAllURIsInSchema(bpel, bpelimpt.getSchema2()));
                if (allimpturis.contains(URIHelper.resolve((URI)bpel.toURI(), (String)bpelimpt.getLocation().toString()))) continue;
                allimpturis.add(URIHelper.resolve((URI)bpel.toURI(), (String)bpelimpt.getLocation().toString()));
            }
            this.createNewProject(result.getProcess().getTargetNamespace(), result.getProcess().getName(), targetDirectory, false);
            String artifactId = result.getProcess().getName().toLowerCase();
            File projectDirectory = new File(targetDirectory.toString() + "/" + artifactId);
            File srcMainResourcesDirectory = new File(projectDirectory.toString() + "/src/main/resources");
            allimpturis.add(bpel.toURI());
            for (URI uris : allimpturis) {
                File imptFile = new File(uris);
                if (!imptFile.exists()) continue;
                FileInputStream source = new FileInputStream(imptFile);
                String oldPath = bpel.toString().substring(0, bpel.toString().lastIndexOf("/"));
                String tmp = uris.toString().replace(oldPath, "");
                String fileName = null;
                String out = null;
                if (tmp.contains("/")) {
                    boolean mkdir = new File(srcMainResourcesDirectory, tmp.substring(0, tmp.lastIndexOf("/"))).mkdirs();
                    fileName = tmp.substring(tmp.lastIndexOf("/"), tmp.length()).replace("/", "");
                    out = srcMainResourcesDirectory.toURI() + tmp;
                } else {
                    fileName = tmp.replace("/", "");
                    out = srcMainResourcesDirectory.toURI() + fileName;
                }
                File outFile = new File(URI.create(out));
                outFile.createNewFile();
                FileOutputStream destination = new FileOutputStream(outFile);
                FileUtil.copy(source, destination);
            }
            File imptFile = new File(bpel.toURI());
            FileInputStream source = new FileInputStream(imptFile);
            String out = srcMainResourcesDirectory.toURI() + result.getProcess().getName() + ".bpel";
            File outFile = new File(URI.create(out));
            outFile.createNewFile();
            FileOutputStream destination = new FileOutputStream(outFile);
            FileUtil.copy(source, destination);
            res = analyzerResult.getProcessDefinition().getQName();
        }
        catch (BPELException e) {
            throw new SDKException(e);
        }
        catch (FileNotFoundException e) {
            throw new SDKException(e);
        }
        catch (IOException e) {
            throw new SDKException(e);
        }
        catch (URISyntaxException e) {
            throw new SDKException(e);
        }
        return res;
    }

    private String findImage(List<URI> uris) {
        String res = null;
        for (URI uri : uris) {
            if (!uri.toString().startsWith(IMAGE_METADATA_PATH)) continue;
            String imagePath = uri.toString().replace(IMAGE_METADATA_PATH + "#", "");
            if (imagePath.startsWith("classpath://")) {
                res = imagePath.replace("classpath://", "");
                break;
            }
            res = imagePath;
            break;
        }
        return res;
    }

    private Collection<? extends URI> getAllURIsInSchema(URL basedir, Schema schema) {
        ArrayList<URI> res = new ArrayList<URI>();
        XmlObjectXPathEvaluator xpathEvaluator = schema.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easyschema10.api.element.Import[] schemaImports = (com.ebmwebsourcing.easyschema10.api.element.Import[])xpathEvaluator.selectXmlObjectNodes((XmlObject)schema, String.format("//xs:import", new Object[0]), com.ebmwebsourcing.easyschema10.api.element.Import.class);
            Include[] schemaIncludes = (Include[])xpathEvaluator.selectXmlObjectNodes((XmlObject)schema, String.format("//xs:include", new Object[0]), Include.class);
            for (com.ebmwebsourcing.easyschema10.api.element.Import import_ : schemaImports) {
                URI imptURI;
                if (import_.getSchemaLocation() == null || res.contains(imptURI = URIHelper.resolve((URI)basedir.toURI(), (String)import_.getSchemaLocation()))) continue;
                res.add(imptURI);
            }
            for (com.ebmwebsourcing.easyschema10.api.element.Import import_ : schemaIncludes) {
                URI inclURI;
                if (import_.getSchemaLocation() == null || res.contains(inclURI = URIHelper.resolve((URI)basedir.toURI(), (String)import_.getSchemaLocation()))) continue;
                res.add(inclURI);
            }
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
        catch (URISyntaxException e) {
            throw new UncheckedException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new UncheckedException((Throwable)e);
        }
        return res;
    }

    private Collection<? extends URI> getAllURIsInDescription(URL basedir, Definitions def) {
        ArrayList<? extends URI> res = new ArrayList<URI>();
        XmlObjectXPathEvaluator xpathEvaluator = def.getXmlContext().createXPathEvaluator();
        try {
            Import[] wsdlImports;
            for (Import import_ : wsdlImports = (Import[])xpathEvaluator.selectXmlObjectNodes((XmlObject)def, String.format("//wsdl11:import", new Object[0]), Import.class)) {
                URI imptURI = URIHelper.resolve((URI)basedir.toURI(), (String)import_.getLocation());
                if (res.contains(imptURI)) continue;
                res.add(imptURI);
            }
            if (def.getTypes() != null) {
                for (Import import_ : (Schema[])def.getTypes().getAnyXmlObjects(Schema.class)) {
                    res.addAll(this.getAllURIsInSchema(basedir, (Schema)import_));
                }
            }
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
        catch (URISyntaxException e) {
            throw new UncheckedException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new UncheckedException((Throwable)e);
        }
        return res;
    }

    private Definitions readDefinitions(URL wsdlUrl) throws XmlObjectReadException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        XmlObjectReader reader = xmlContext.createReader();
        Definitions definitions = (Definitions)reader.readDocument(wsdlUrl, Definitions.class);
        return definitions;
    }

    public int importProjectIntoEclipse(File projectDirectory, PrintStream ps) throws SDKException {
        int res = 1;
        String javaPath = System.getenv("JAVA_HOME");
        if (javaPath == null) {
            throw new SDKException("JAVA_HOME must be setted!!!");
        }
        String mavenPath = System.getenv("MAVEN_HOME");
        if (mavenPath == null) {
            this.log.warning("MAVEN_HOME is not setted...");
        }
        try {
            String script = null;
            if (OSValidator.isWindows()) {
                script = new String(new File(".").getAbsolutePath() + this.scriptPath + "/easiest-eclipse.bat").replace("..", "");
            } else if (OSValidator.isMac() || OSValidator.isUnix()) {
                script = new String(new File(".").getAbsolutePath() + this.scriptPath + "/easiest-eclipse.sh").replace("..", "");
            } else {
                throw new SDKException("Sorry, but this OS is not supported. EasiestDEMO SDK run on Windows, Mac or Unix system.");
            }
            System.out.println("script = " + script);
            ProcessBuilder pb = new ProcessBuilder(script);
            pb.redirectErrorStream(true);
            pb.directory(projectDirectory);
            Process p = pb.start();
            if (ps == null) {
                ps = System.out;
            }
            this.writeInputStream(p.getInputStream(), ps);
            this.writeInputStream(p.getErrorStream(), ps);
            p.waitFor();
            res = p.exitValue();
        }
        catch (IOException e) {
            throw new SDKException(e);
        }
        catch (InterruptedException e) {
            throw new SDKException(e);
        }
        return res;
    }

    public int compileProject(File projectDirectory, PrintStream ps) throws SDKException {
        int res = 1;
        String javaPath = System.getenv("JAVA_HOME");
        if (javaPath == null) {
            throw new SDKException("JAVA_HOME must be setted!!!");
        }
        String mavenPath = System.getenv("MAVEN_HOME");
        if (mavenPath == null) {
            this.log.warning("MAVEN_HOME is not setted!!!");
        }
        try {
            String script = null;
            if (OSValidator.isWindows()) {
                script = new String(new File(".").getAbsolutePath() + this.scriptPath + "/easiest-compile.bat").replace("..", "");
            } else if (OSValidator.isMac() || OSValidator.isUnix()) {
                script = new String(new File(".").getAbsolutePath() + this.scriptPath + "/easiest-compile.sh").replace("..", "");
            } else {
                throw new SDKException("Sorry, but this OS is not supported. EasiestDEMO SDK run on Windows, Mac or Unix system");
            }
            System.out.println("script = " + script);
            ProcessBuilder pb = new ProcessBuilder(script);
            pb.redirectErrorStream(true);
            pb.directory(projectDirectory);
            Process p = pb.start();
            if (ps == null) {
                ps = System.out;
            }
            this.writeInputStream(p.getInputStream(), ps);
            this.writeInputStream(p.getErrorStream(), ps);
            p.waitFor();
            res = p.exitValue();
        }
        catch (IOException e) {
            throw new SDKException(e);
        }
        catch (InterruptedException e) {
            throw new SDKException(e);
        }
        return res;
    }

    public int runProject(File projectDirectory, PrintStream ps) throws SDKException {
        int res = 1;
        String javaPath = System.getenv("JAVA_HOME");
        if (javaPath == null) {
            throw new SDKException("JAVA_HOME must be setted!!!");
        }
        try {
            List<File> scripts;
            File startAllScript = null;
            if (OSValidator.isWindows()) {
                scripts = Arrays.asList(FileUtil.findFilesInDirectory("StartAll.bat", projectDirectory));
                if (scripts.size() != 2) {
                    throw new SDKException("too much startAll file: " + scripts);
                }
                for (File script : FileUtil.findFilesInDirectory("StartAll.bat", projectDirectory)) {
                    if (script.toString().contains("target\\global-scripts")) continue;
                    startAllScript = script;
                    break;
                }
            } else if (OSValidator.isMac() || OSValidator.isUnix()) {
                scripts = Arrays.asList(FileUtil.findFilesInDirectory("StartAll.sh", projectDirectory));
                if (scripts.size() != 2) {
                    throw new SDKException("too much startAll file: " + scripts);
                }
                for (File script : FileUtil.findFilesInDirectory("StartAll.sh", projectDirectory)) {
                    if (script.toString().contains("target/global-scripts")) continue;
                    startAllScript = script;
                    break;
                }
            } else {
                throw new SDKException("Sorry, but this OS is not supported. EasiestDEMO SDK run on Windows, Mac or Unix system");
            }
            ThreadRun run = new ThreadRun(startAllScript, ps);
            run.start();
        }
        catch (IOException e) {
            throw new SDKException(e);
        }
        catch (InterruptedException e) {
            throw new SDKException(e);
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        return res;
    }

    private void writeInputStream(InputStream ips, PrintStream ps) throws IOException {
        String ligne;
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((ligne = br.readLine()) != null) {
            System.out.println(ligne);
            System.out.flush();
        }
        br.close();
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }
}

