/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class POMGenerator {
    private String groupId;
    private String artefactId;
    private String version;
    private String bpelProcessName;
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    public POMGenerator(String groupId, String artefactId, String version, String bpelProcessName) {
        this.groupId = groupId;
        this.artefactId = artefactId;
        this.version = version;
        this.bpelProcessName = bpelProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String bpelUrl, String basedir) throws IOException, Exception {
        File f = new File(bpelUrl + "/" + basedir + "/pom.xml");
        FileWriter writer = null;
        String mavenWsouiPluginVersion = "1.0-SNAPSHOT";
        try {
            String lastVersion = this.findMavenWsouiPluginLastVersion("http://maven.petalslink.com/public-research/com/ebmwebsourcing/easiestdemo/maven-wsoui-plugin/");
            if (lastVersion != null) {
                mavenWsouiPluginVersion = lastVersion;
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to retrieve Maven Wsoui plugin latest version ... taking 1.0-SNAPSHOT one instead.");
        }
        try {
            writer = new FileWriter(f);
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            writer.write("       xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n");
            writer.write("\t\t<modelVersion>4.0.0</modelVersion>\n");
            writer.write("\t\t<name>" + this.artefactId + "</name>\n");
            writer.write("\t\t<artifactId>" + this.artefactId + "</artifactId>\n");
            writer.write("\t\t<groupId>" + this.groupId + "</groupId>\n");
            writer.write("\t\t<version>" + this.version + "</version>\n");
            writer.write("\t\t<packaging>jar</packaging>\n");
            writer.write("\t\t<dependencies>\n");
            writer.write("\t\t\t<dependency>\n");
            writer.write("\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\n");
            writer.write("\t\t\t\t<artifactId>maven-wsoui-plugin</artifactId>\n");
            writer.write("\t\t\t\t<version>" + mavenWsouiPluginVersion + "</version>\n");
            writer.write("\t\t\t</dependency>\n");
            writer.write("\t\t</dependencies>\n");
            writer.write("\t\t\t<build>\n");
            writer.write("\t\t\t\t<plugins>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>com.ebmwebsourcing.easiestdemo</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-wsoui-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t<version>" + mavenWsouiPluginVersion + "</version>\n");
            writer.write("\t\t\t\t\t\t<executions>\n");
            writer.write("\t\t\t\t\t\t\t<execution>\n");
            writer.write("\t\t\t\t\t\t\t\t<id>generate-sources</id>\n");
            writer.write("\t\t\t\t\t\t\t\t<phase>generate-sources</phase>\n");
            writer.write("\t\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<bpelOptions>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t<bpelOption>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<bpel>${basedir}/src/main/resources/" + this.bpelProcessName + ".bpel</bpel>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<overrideOlderBusinessClass>true</overrideOlderBusinessClass>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</bpelOption>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</bpelOptions>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<goals>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<goal>bpel2java</goal>\n");
            writer.write("\t\t\t\t\t\t\t\t</goals>\n");
            writer.write("\t\t\t\t\t\t\t</execution>\n");
            writer.write("\t\t\t\t\t\t</executions>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-jar-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<finalName>server</finalName>\n");
            writer.write("\t\t\t\t\t\t\t\t<archive>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<manifest>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\t<addClasspath>true</addClasspath>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t</manifest>\n");
            writer.write("\t\t\t\t\t\t\t\t</archive>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t\t<artifactId>maven-assembly-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t\t<executions>\n");
            writer.write("\t\t\t\t\t\t\t\t<execution>\n");
            writer.write("\t\t\t\t\t\t\t\t<id>dev-assembly</id>\n");
            writer.write("\t\t\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<appendAssemblyId>false</appendAssemblyId>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<attach>false</attach>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<descriptors>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t<descriptor>\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t\ttarget/assembly/dev.xml\n");
            writer.write("\t\t\t\t\t\t\t\t\t\t</descriptor>\n");
            writer.write("\t\t\t\t\t\t\t\t\t</descriptors>\n");
            writer.write("\t\t\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t\t\t\t<phase>package</phase>\n");
            writer.write("\t\t\t\t\t\t\t\t<goals>\n");
            writer.write("\t\t\t\t\t\t\t\t\t<goal>attached</goal>\n");
            writer.write("\t\t\t\t\t\t\t\t</goals>\n");
            writer.write("\t\t\t\t\t\t\t\t</execution>\n");
            writer.write("\t\t\t\t\t\t</executions>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t\t<plugin>\n");
            writer.write("\t\t\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\n");
            writer.write("\t\t\t\t\t\t<artifactId>maven-compiler-plugin</artifactId>\n");
            writer.write("\t\t\t\t\t\t<configuration>\n");
            writer.write("\t\t\t\t\t\t\t<source>1.6</source>\n");
            writer.write("\t\t\t\t\t\t\t<target>1.6</target>\n");
            writer.write("\t\t\t\t\t\t\t<showDeprecation>true</showDeprecation>\n");
            writer.write("\t\t\t\t\t\t</configuration>\n");
            writer.write("\t\t\t\t\t</plugin>\n");
            writer.write("\t\t\t\t</plugins>\n");
            writer.write("\t\t\t</build>\n");
            writer.write("\t\t<repositories>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-research-public.release</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-research</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.release</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.snapshot</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-snapshot</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t\t<repository>\n");
            writer.write("\t\t\t\t<id>ebmws-others</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/others</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</repository>\n");
            writer.write("\t\t</repositories>\n");
            writer.write("\t\t<pluginRepositories>\n");
            writer.write("\t\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t\t<id>ebmws-research-public.release</id>\n");
            writer.write("\t\t\t\t\t<url>http://maven.petalslink.com/public-research</url>\n");
            writer.write("\t\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t\t<id>ebmws-public.release</id>\n");
            writer.write("\t\t\t\t\t<url>http://maven.petalslink.com/public</url>\n");
            writer.write("\t\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t<id>ebmws-public.snapshot</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/public-snapshot</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</pluginRepository>\n");
            writer.write("\t\t\t<pluginRepository>\n");
            writer.write("\t\t\t\t<id>ebmws-others</id>\n");
            writer.write("\t\t\t\t<url>http://maven.petalslink.com/others</url>\n");
            writer.write("\t\t\t\t<releases>\n");
            writer.write("\t\t\t\t\t<enabled>true</enabled>\n");
            writer.write("\t\t\t\t</releases>\n");
            writer.write("\t\t\t\t<snapshots>\n");
            writer.write("\t\t\t\t\t<enabled>false</enabled>\n");
            writer.write("\t\t\t\t</snapshots>\n");
            writer.write("\t\t\t</pluginRepository>\n");
            writer.write("\t\t</pluginRepositories>\n");
            writer.write("</project>\n");
            writer.write("");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public String findMavenWsouiPluginLastVersion(String url) throws MalformedURLException, IOException, ParseException {
        String line;
        String lastVersion = null;
        InputStream is = new URL(url).openStream();
        InputStreamReader ipsr = new InputStreamReader(is, "UTF-8");
        BufferedReader br = new BufferedReader(ipsr);
        String buffer = "";
        while ((line = br.readLine()) != null) {
            buffer = buffer + line + "\n";
        }
        br.close();
        String table = this.getTable(buffer);
        if (table != null) {
            List<String> rows = this.getRows(table);
            SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd");
            Date lastDate = new Date(1L);
            for (String row : rows) {
                String newversion;
                Date d;
                String href = this.getHRef(row);
                String version = this.getName(href).replace("/", "");
                if (version.contains(".") || version.contains("Parent Directory") || !(d = parser.parse(newversion = version.substring(1))).after(lastDate)) continue;
                lastDate = d;
                lastVersion = version;
            }
        }
        return lastVersion;
    }

    private String getTable(String buffer) {
        String res = null;
        int start = buffer.indexOf("<table");
        int end = buffer.lastIndexOf("</table>");
        if (start != -1 && end != -1) {
            res = buffer.substring(start, end + "</table>".length()).trim();
        }
        return res;
    }

    private List<String> getRows(String table) {
        ArrayList<String> res = new ArrayList<String>();
        String[] rows = table.replace("<table>", "").replace("</table>", "").trim().split("</tr>");
        if (rows.length > 1) {
            for (int i = 1; i < rows.length; ++i) {
                res.add(rows[i] + "</tr>");
            }
        }
        return res;
    }

    private String getHRef(String row) {
        String res = row.substring(row.indexOf("<a"), row.indexOf("</a>") + "</a>".length());
        return res;
    }

    private String getName(String href) {
        String res = href.substring(href.indexOf(">") + 1, href.lastIndexOf("<"));
        return res;
    }
}

