package org.petalslink.easiestdemo.sdk.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

import com.ebmwebsourcing.easycommons.uri.URIHelper;

public class FileUtil {


	public static File[] getAllDirectories( File parentDir ) throws Exception {
		List<File> list = new ArrayList<File>();
		if (parentDir.isDirectory()) {
			list.addAll(Arrays.asList(parentDir.listFiles()));
			List<File> listTmp = new ArrayList<File>();
			for(File current: list) {
				if(current.isDirectory()) {
					listTmp.addAll(Arrays.asList(getAllDirectories(current)));
				}
			} 
			list.addAll(listTmp);
		} 
		return list.toArray(new File[list.size()]);
	} 

	public static File[] getAllFiles(File parentDir) throws Exception {
		List<File> list = new ArrayList<File>();
		if(parentDir != null) {
			for(File dir: FileUtil.getAllDirectories(parentDir)) {
				File [] fs = dir.listFiles();
				if(fs != null) {
					list.addAll(Arrays.asList(fs));
				}
			}
			list.addAll(Arrays.asList(parentDir.listFiles()));
		}
		return list.toArray(new File[list.size()]);
	} 
	
	public static void removeDirectory(File parentDir) throws Exception {
		for(File f: Arrays.asList(getAllFiles(parentDir))) {
			f.delete();
		}
		for(File f: Arrays.asList(getAllDirectories(parentDir))) {
			f.delete();
		}
	}
	
	public static File[] findFilesInDirectory(String shortFileName, File parentDir) throws Exception {
		List<File> res = new ArrayList<File>();
		List<File> files = Arrays.asList(getAllFiles(parentDir));
		for(File f: files) {
			if(f.getName().equals(shortFileName)) {
				res.add(f);
			}
		}
		return res.toArray(new File[res.size()]);
	}


	public static File createFile(String className, String packageName, String basedir, String extension, boolean override, boolean isExecutable) {
		File f = new File(basedir + "/" + packageName.replace(".", "/") + "/"+ className + extension);
		if(override == false) {
			int cpt = 1;
			while(f.exists()) {
				f = new File(basedir + "/" + packageName.replace(".", "/") + "/"+ className + "(" + cpt + ")" + extension);
				cpt++;
			}
		}
		f.setExecutable(isExecutable);
		return f;
	}
	
	public static File createFile(String fileName, String basedir, String extension, boolean override, boolean isExecutable) {
		File f = new File(basedir + "/" + fileName + extension);
		if(override == false) {
			int cpt = 1;
			while(f.exists()) {
				f = new File(basedir + "/" + fileName + "(" + cpt + ")" + extension);
				cpt++;
			}
		}
		f.setExecutable(isExecutable);
		return f;
	}

	public static String createPackageNameFromTargetNamespace(String targetNamespace) {
		URI tns = URI.create(targetNamespace);
		String res = "";
		if(tns.getHost() != null) {
			StringTokenizer st = new StringTokenizer(tns.getHost(), ".");
			while(st.hasMoreTokens()) {
				String part = st.nextToken();
				if(!part.equals("www")) {
					res = part + "." + res;
				}
			}
		}
		res = res + tns.getPath().replace(".", "_").replace("/", ".").replace("\\", ".");
		res = res.replace("..", ".");
		return res;
	}


	public static URI getURI(URI baseURI, String relativePath) throws MalformedURLException, URISyntaxException {
		URI res = null;
		if(relativePath.startsWith("file:")) {
			res = URI.create(relativePath);
		} else {
			File file = new File(relativePath);
			res = file.exists() ? file.toURI() 
					: URIHelper.resolve(baseURI, relativePath);
		}
		return res;
	}


	public static boolean copy(InputStream source, OutputStream destination ) { 
		boolean resultat = false;

		InputStream sourceFile=null;
		OutputStream destinationFile=null;
		try {
			sourceFile = source;
			destinationFile = destination;
			byte buffer[]=new byte[512*1024];
			int nbLecture;
			while( (nbLecture = sourceFile.read(buffer)) != -1 ) {
				destinationFile.write(buffer, 0, nbLecture);
			}

			resultat = true;
		} catch( java.io.FileNotFoundException f ) {
		} catch( java.io.IOException e ) {
		} finally {
			try {
				sourceFile.close();
			} catch(Exception e) { }
			try {
				destinationFile.close();
			} catch(Exception e) { }
		}
		return( resultat );
	}
	
	public static String createShortClassName(String clazz) {
		String shortClass = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
		return shortClass;
	}
}

