package com.ebmwebsourcing.easybox.api;

import java.net.URL;

import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/**
 * Class aimed at reading {@link XmlObject} instances from different sources.
 * 
 * @author mjambert
 */
public interface XmlObjectReader {

    public static enum ReadMode { LAZY, FULL };
    
    /**
     * Get read mode.
     * 
     * @return Read mode used by this {@link XmlObjectReader}.
     */
    ReadMode getReadMode();
    
    /**
     * Set read mode.
     * 
     * @param readMode New read mode to be used by this {@link XmlObjectReader}.
     */
    void setReadMode(ReadMode readMode);

    void setEntityResolver(EntityResolver entityResolver);
    
    <X extends XmlObject> X readDocument(URL url, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;


    <X extends XmlObject> X readDocument(InputSource inputSource, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;


    <X extends XmlObject> X readDocument(java.io.InputStream inputStream, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;


    <X extends XmlObject> X readDocument(Document document, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;

    
    <X extends XmlObject> X readFragment(URL url, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;
    
    
    <X extends XmlObject> X readFragment(InputSource inputSource, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;

    
    <X extends XmlObject> X readFragment(java.io.InputStream inputStream, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;

    
    <X extends XmlObject> X readFragment(Document document, Class<X> xmlObjectInterfaceClass) throws XmlObjectReadException;
    
}
