package com.ebmwebsourcing.easybox.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class Catalog {

    private static Catalog INSTANCE;

    
    private CatalogManager catalogManager;
    private List<File> catalogFiles;

    private final Map<String, URI> resolvedUriCache;
    
    
    public Catalog() {
        this.catalogManager = null;
        this.catalogFiles = new ArrayList<File>();
        this.resolvedUriCache = new HashMap<String, URI>();
    }
    
    
    public static Catalog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Catalog();
        }
        return INSTANCE;
    }

    public static void setInstance(Catalog instance) {
        INSTANCE = instance;
    }
    
    
    private void resetCatalogManager() {
        catalogManager = null;
        resolvedUriCache.clear();
    }
    
    
    private CatalogManager getCatalogManager() {
        if (catalogManager == null) {
            catalogManager = new CatalogManager();
            catalogManager.setUseStaticCatalog(false);
            catalogManager.setIgnoreMissingProperties(true);
            StringBuffer sb = new StringBuffer();
            for (File catalogFile : catalogFiles) {
                sb.append(catalogFile.getAbsolutePath());
                sb.append(",");
            }
            if (sb.length() > 0) sb.deleteCharAt(sb.length() - 1);
            catalogManager.setCatalogFiles(sb.toString());
        }
        return catalogManager;
    }
    
    
    public void addCatalogFile(File catalogFile) {
        catalogFiles.add(catalogFile);
        resetCatalogManager();
    }
    
    
    public EntityResolver newEntityResolver() {
        return new CatalogResolver(getCatalogManager());
    }
    
    
    public URI resolveUri(URI uri) {
        assert uri != null;
        return resolveUri(String.valueOf(uri));
    }
    
    
    public URI resolveUri(String uri) {
        assert uri != null;
        if (resolvedUriCache.containsKey(uri)) return resolvedUriCache.get(uri);
        try {
            String resolvedUri = getCatalogManager().getCatalog().resolveURI(uri);
            URI result = null;
            if (resolvedUri != null) {
                result = URI.create(resolvedUri);
            }
            resolvedUriCache.put(uri, result);
            return result;
        } catch (MalformedURLException e) {
            throw new UncheckedException(String.format("Cannot resolve URI '%s' (MalformedURLException).", uri));
        } catch (IOException e) {
            throw new UncheckedException(String.format("Cannot resolve URI '%s' (IOException).", uri));
        }
    }
    
    
}
