package com.ebmwebsourcing.easybox.api;

public interface XmlObjectSchemaBinding extends XmlObjectBinding {
    
    /**
     * Get package of {@link ModelObject} objects that this delegate knows how
     * to wrap.
     * 
     * @return {@link ModelObject} objects package.
     */
    Package getModelObjectPackage();
    
    /**
     * Get the name of the originating schema directory resource. The
     * originating schema is the schema which was used to generate corresponding
     * {@link ModelObject} objects.
     * 
     * @return /-separated path name that identifies the schema directory
     *         resource path.
     */
    String getOriginatingSchemaDir();

    /**
     * Get the name of the originating schema file. The originating schema is
     * the schema which was used to generate corresponding {@link ModelObject}
     * objects.
     * 
     * @return Simple schema file name, without path.
     */
    String getOriginatingSchemaName();

    /**
     * Get the namespace URI of the originating schema file. The originating
     * schema is the schema which was used to generate corresponding
     * {@link ModelObject} objects.
     * 
     * @return Schema namespace URI.
     */
    String getOriginatingSchemaNamespaceURI();

    /**
     * Get preferred prefix for the originating schema namespace URI. This
     * prefix will be preferably used for marshalling. The originating schema is
     * the schema which was used to generate corresponding {@link ModelObject}
     * objects.
     * 
     * @return Preferred prefix for the originating schema namespace URI.
     */
    String getOriginatingSchemaPreferredNamespacePrefix();

}
