package com.ebmwebsourcing.easybox.api;

import javax.xml.transform.URIResolver;

import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;



/**
 * {@link XmlContext} is the entity in charge of marshalling/unmarshalling
 * related tasks, given all the {@link XmlObjectBinding} that can be found in
 * classpath.<br/>
 * It is perfectly safe to share a single instance of {@link XmlContext} in the
 * whole application.
 * 
 * @author mjambert
 * 
 */
public interface XmlContext {

	void addXmlObjectBindings(String... bindingNames);
	
    void removeXmlObjectBindings(String... bindingNames);

    void clearXmlObjectBindings();

    XmlObjectBinding[] getXmlObjectBindings();

	/**
	 * Get {@link XmlObjectFactory}.
	 * 
	 * @return {@link XmlObjectFactory} associated with this context.
	 */
	XmlObjectFactory getXmlObjectFactory();
	
    /**
     * Create a new {@link XmlObjectReader}.
     * 
     * @return Newly created reader.
     */
    XmlObjectReader createReader();

    /**
     * Create a new {@link XmlObjectValidator}.
     * 
     * @return Newly created validator.
     */
    XmlObjectValidator createValidator();

    /**
     * Create a new {@link XmlObjectWriter}.
     * 
     * @return Newly created writer.
     */
    XmlObjectWriter createWriter();
    
    
    XmlObjectXPathEvaluator createXPathEvaluator();

    ClassMetadata getClassMetadata();

    XmlObjectXQueryEvaluator createXQueryEvaluator();

    XmlObjectXQueryValidator createXQueryValidator();
    
    URIResolver getURIResolver();
    
    void setURIResolver(URIResolver uriResolver);

}
