package com.ebmwebsourcing.easybox.api.analysis;

import com.ebmwebsourcing.easybox.api.XmlObjectNode;

public class UnexpectedPublicImplementationException extends AnalyzerException {

    private static final long serialVersionUID = 1430916069354799771L;
    
    private static final String MESSAGE = 
        "Implementation class '%s' should not be public.";
    
    public UnexpectedPublicImplementationException(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) {
        super(String.format(MESSAGE, xmlObjectNodeImplClass.getSimpleName()));
    }

    
}
