/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api.with;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.AnyXmlObject;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithAnyXmlObjects;
import com.ebmwebsourcing.easycommons.lang.ArrayHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithAnyXmlObjectsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_ANY_XML_OBJECTS = "expectedAnyXmlObjects";

    public WithAnyXmlObjectsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetAnyXmlObjects() {
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        Object[] expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS);
        Assert.assertArrayEquals((Object[])expectedAnyXmlObjects, (Object[])withAnyXmlObjects.getAnyXmlObjects());
    }

    @Test
    public void testHasAnyXmlObjectWithQName() {
        XmlObject[] expectedAnyXmlObjects;
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        for (XmlObject anyXmlObject : expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS)) {
            Assert.assertTrue((boolean)withAnyXmlObjects.hasAnyXmlObject(anyXmlObject.getXmlObjectQName()));
        }
    }

    @Test
    public void testGetAnyXmlObjectsWithQName() {
        XmlObject[] expectedAnyXmlObjects;
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        for (XmlObject expectedAnyXmlObject : expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS)) {
            for (XmlObject anyXmlObject : withAnyXmlObjects.getAnyXmlObjects(expectedAnyXmlObject.getXmlObjectQName())) {
                Assert.assertEquals((Object)expectedAnyXmlObject.getXmlObjectQName(), (Object)anyXmlObject.getXmlObjectQName());
            }
        }
    }

    @Test
    public void testGetAnyXmlObjectsImplementingInterface() {
        XmlObject[] expectedAnyXmlObjects;
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        for (XmlObject expectedAnyXmlObject : expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS)) {
            Class interfaceClass = (Class)this.getXmlContext().getClassMetadata().get(expectedAnyXmlObject.getClass(), "implementationClassInterface");
            for (XmlObject anyXmlObject : withAnyXmlObjects.getAnyXmlObjects(interfaceClass)) {
                Assert.assertTrue((boolean)interfaceClass.isInstance(anyXmlObject));
            }
        }
    }

    @Test
    public void testGetFirstAnyXmlObjectsImplementingInterface() {
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        XmlObject[] expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS);
        XmlObject expectedFirstAnyXmlObject = expectedAnyXmlObjects.length == 0 ? null : expectedAnyXmlObjects[0];
        Class<AnyXmlObject> interfaceClass = expectedFirstAnyXmlObject == null ? AnyXmlObject.class : this.getXmlContext().getClassMetadata().get(expectedFirstAnyXmlObject.getClass(), "implementationClassInterface");
        Assert.assertEquals((Object)expectedFirstAnyXmlObject, (Object)withAnyXmlObjects.getFirstAnyXmlObject(interfaceClass));
    }

    @Test
    public void testAddAnyXmlObject() {
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        Object[] expectedAnyXmlObjects = (XmlObject[])this.getTestData(EXPECTED_ANY_XML_OBJECTS);
        XmlObject newAnyXmlObject = (XmlObject)this.getXmlContext().getXmlObjectFactory().create(AnyXmlObject.class);
        expectedAnyXmlObjects = (XmlObject[])ArrayHelper.mergeArrays((Object[][])new XmlObject[][]{expectedAnyXmlObjects, {newAnyXmlObject}});
        withAnyXmlObjects.addAnyXmlObject(newAnyXmlObject);
        Assert.assertArrayEquals((Object[])expectedAnyXmlObjects, (Object[])withAnyXmlObjects.getAnyXmlObjects());
    }

    @Test
    public void testRemoveAnyXmlObject() {
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        for (XmlObject anyXmlObject : withAnyXmlObjects.getAnyXmlObjects()) {
            int count = withAnyXmlObjects.getAnyXmlObjects().length;
            withAnyXmlObjects.removeAnyXmlObject(anyXmlObject);
            Assert.assertEquals((long)(count - 1), (long)withAnyXmlObjects.getAnyXmlObjects().length);
        }
    }

    @Test
    public void testClearAnyXmlObject() {
        WithAnyXmlObjects withAnyXmlObjects = (WithAnyXmlObjects)this.newXmlObjectUnderTest();
        withAnyXmlObjects.clearAnyXmlObjects();
        Assert.assertEquals((long)0L, (long)withAnyXmlObjects.getAnyXmlObjects().length);
    }
}

