/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.api;

import javax.xml.transform.URIResolver;

import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;



/**
 * {@link XmlContext} is the entity in charge of marshalling/unmarshalling
 * related tasks, given all the {@link XmlObjectBinding} that can be found in
 * classpath.<br/>
 * It is perfectly safe to share a single instance of {@link XmlContext} in the
 * whole application.
 * 
 * @author mjambert
 * 
 */
public interface XmlContext {

	void addXmlObjectBindings(String... bindingNames);
	
    void removeXmlObjectBindings(String... bindingNames);

    void clearXmlObjectBindings();

    XmlObjectBinding[] getXmlObjectBindings();

	/**
	 * Get {@link XmlObjectFactory}.
	 * 
	 * @return {@link XmlObjectFactory} associated with this context.
	 */
	XmlObjectFactory getXmlObjectFactory();
	
    /**
     * Create a new {@link XmlObjectReader}.
     * 
     * @return Newly created reader.
     */
    XmlObjectReader createReader();

    /**
     * Create a new {@link XmlObjectValidator}.
     * 
     * @return Newly created validator.
     */
    XmlObjectValidator createValidator();

    /**
     * Create a new {@link XmlObjectWriter}.
     * 
     * @return Newly created writer.
     */
    XmlObjectWriter createWriter();
    
    
    XmlObjectXPathEvaluator createXPathEvaluator();

    ClassMetadata getClassMetadata();

    XmlObjectXQueryEvaluator createXQueryEvaluator();

    XmlObjectXQueryValidator createXQueryValidator();
    
    URIResolver getURIResolver();
    
    void setURIResolver(URIResolver uriResolver);

}
