/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.api;

/**
 * Interface to be implemented by classes allowed to create instances of
 * {@link XmlObject}.
 * 
 * @author mjambert
 * 
 */
public interface XmlObjectBinding {

    
    /**
     * Get unique name of this binding.
     * 
     * @return Name of this binding.
     */
    String getName();
    
    /**
     * Get array of classes for which this factory delegate can factor
     * objects.
     * 
     * @return Array of {@link XmlObject} implementation classes.
     */
    Class<? extends XmlObjectNode>[] getFactorableClasses(); 


    
    /**
     * Return whether or not this delegate can wrap a given internal model object.
     * 
     * @param obj
     *            Object to be wrapped into an {@link XmlObject}.
     * @return {@code true} if this delegate can wrap {@code obj}, {@code false} otherwise.
     */
    boolean canWrap(Object obj);

    /**
     * Wrap an internal model object into an implementation of {@link XmlObject}
     * .
     * 
     * @param <X>
     *            Type of desired {@link XmlObject} implementation.
     * @param xmlContext Associated {@link XmlContext}.
     * @param xmlObjectImplClass
     *            Concrete class to be instantiated.
     * @param obj
     *            Model object to be wrapped.
     * @return Newly created {@link XmlObject}.
     */
    <X extends XmlObjectNode> X wrap(XmlContext xmlContext, Class<X> xmlObjectImplClass, Object obj);

    /**
     * Wrap any internal model object into an {@link XmlObject}, guessing the
     * proper {@link XmlObject} implementation.
     * 
     * @param xmlContext Associated {@link XmlContext}.
     * @param obj
     *            Model object to be wrapped.
     * @return Newly created {@link XmlObject}.
     */
    XmlObjectNode wrap(XmlContext xmlContext, Object obj);

    /**
     * Create a new {@link XmlObject}.
     * 
     * @param <X>
     *            Type of desired {@link XmlObject} implementation.
     * @param xmlContext Associated {@link XmlContext}.
     * @param xmlObjectImplClass
     *            Concrete class to be instantiated.
     * @return Newly created concrete {@link XmlObject}.
     */
    <X extends XmlObjectNode> X create(XmlContext xmlContext, Class<X> xmlObjectImplClass);


    
    
}
