/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.api.analysis;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class ClassMetadata {

    private Map<Class<?>, Map<String, Object>> classesMetadata = new IdentityHashMap<Class<?>, Map<String, Object>>();

    public ClassMetadata() {
    }

    private final Map<String, Object> doGet(Class<?> clazz) {
        if (!classesMetadata.containsKey(clazz)) {
            classesMetadata.put(clazz, new HashMap<String, Object>());
        }
        return classesMetadata.get(clazz);
    }

    public void clear() {
    	classesMetadata.clear();
    }
    
    
    public boolean has(Class<?> clazz, String key) {
        return doGet(clazz).containsKey(key);
    }
    
    
    @SuppressWarnings("unchecked")
    public <X> X get(Class<?> clazz, String key) {
        Map<String, Object> classMetadata = doGet(clazz);
        if (!classMetadata.containsKey(key)) {
            throw new UncheckedException(String.format(
                    "No such key '%s' in class '%s' metadata.", key,
                    clazz.getName()));
        }
        return (X) classMetadata.get(key);
    }
    
    
    public void put(Class<?> clazz, String key, Object classMetadata) {
        doGet(clazz).put(key, classMetadata);
    }

}
