/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbReflectionFieldInfo;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlIDREF;

final class JaxbReflectionInfo {
    public static final String JAXB_ATTRIBUTE_NAME_DEFAULT = "##default";
    public static final Class<?> JAXB_ATTRIBUTE_TYPE_DEFAULT = XmlElement.DEFAULT.class;
    private static final Map<Class<? extends ModelObject>, JaxbReflectionInfo> jaxbReflectionInfos = new HashMap<Class<? extends ModelObject>, JaxbReflectionInfo>();
    private final Class<? extends ModelObject> modelObjectClass;
    private final Map<String, JaxbReflectionFieldInfo> childrenFieldInfos;
    private final Map<String, JaxbReflectionFieldInfo> attributeFieldInfos;

    JaxbReflectionInfo(Class<? extends ModelObject> modelObjectClass) {
        this.modelObjectClass = modelObjectClass;
        this.childrenFieldInfos = new LinkedHashMap<String, JaxbReflectionFieldInfo>();
        this.attributeFieldInfos = new LinkedHashMap<String, JaxbReflectionFieldInfo>();
        this.populateFields();
    }

    static JaxbReflectionInfo getReflectionInfo(Class<? extends ModelObject> modelObjectClass) {
        if (!jaxbReflectionInfos.containsKey(modelObjectClass)) {
            jaxbReflectionInfos.put(modelObjectClass, new JaxbReflectionInfo(modelObjectClass));
        }
        return jaxbReflectionInfos.get(modelObjectClass);
    }

    Collection<JaxbReflectionFieldInfo> getFieldInfos() {
        ArrayList<JaxbReflectionFieldInfo> fieldInfos = new ArrayList<JaxbReflectionFieldInfo>();
        fieldInfos.addAll(this.attributeFieldInfos.values());
        fieldInfos.addAll(this.childrenFieldInfos.values());
        return fieldInfos;
    }

    Collection<JaxbReflectionFieldInfo> getChildrenFieldInfos() {
        return this.childrenFieldInfos.values();
    }

    JaxbReflectionFieldInfo getChildFieldInfoByName(String name) {
        return this.childrenFieldInfos.get(name);
    }

    Collection<JaxbReflectionFieldInfo> getAttributeFields() {
        return this.attributeFieldInfos.values();
    }

    private static boolean isJaxbComplexTypeClass(Class<?> fieldClass) {
        return JAXBElement.class.equals(fieldClass) || ModelObject.class.isAssignableFrom(fieldClass);
    }

    private static boolean isComplexChildField(Field field) {
        if (ModelObject.class.isAssignableFrom(field.getType()) || JaxbReflectionInfo.isModelObjectCollectionField(field)) {
            return true;
        }
        if (field.isAnnotationPresent(XmlElements.class)) {
            XmlElement[] xmlElements;
            for (XmlElement xmlElement : xmlElements = field.getAnnotation(XmlElements.class).value()) {
                if (!JaxbReflectionInfo.isJaxbComplexTypeClass(xmlElement.type())) continue;
                return true;
            }
            return false;
        }
        if (field.isAnnotationPresent(XmlElementRefs.class)) {
            XmlElementRef[] xmlElementRefs;
            for (XmlElementRef xmlElementRef : xmlElementRefs = field.getAnnotation(XmlElementRefs.class).value()) {
                if (!JaxbReflectionInfo.isJaxbComplexTypeClass(xmlElementRef.type())) continue;
                return true;
            }
            return false;
        }
        if (JaxbReflectionInfo.isJaxbComplexTypeClass(JaxbReflectionInfo.getOverridenTypeOrType(field))) {
            return true;
        }
        if (field.isAnnotationPresent(XmlAnyElement.class)) {
            return true;
        }
        return JaxbReflectionInfo.isModelObjectIdRef(field);
    }

    private static Class<?> getOverridenTypeOrType(Field attributeField) {
        Class<?> attributeType = attributeField.getType();
        if (attributeField.isAnnotationPresent(XmlElement.class)) {
            attributeType = attributeField.getAnnotation(XmlElement.class).type();
        }
        if (attributeField.isAnnotationPresent(XmlElementRef.class)) {
            attributeType = attributeField.getAnnotation(XmlElementRef.class).type();
        }
        if (JAXB_ATTRIBUTE_TYPE_DEFAULT.equals(attributeType)) {
            attributeType = attributeField.getType();
        }
        return attributeType;
    }

    private static boolean isAttributeField(Field field) {
        return !ModelObject.class.isAssignableFrom(field.getType()) && !JaxbReflectionInfo.isModelObjectCollectionField(field) && !JaxbReflectionInfo.isModelObjectIdRef(field);
    }

    private static boolean isModelObjectIdRef(Field field) {
        return field.isAnnotationPresent(XmlIDREF.class);
    }

    private static String getOverridenNameOrName(Field attributeField) {
        String attributeName = attributeField.getName();
        if (attributeField.isAnnotationPresent(XmlAttribute.class)) {
            attributeName = attributeField.getAnnotation(XmlAttribute.class).name();
        }
        if (attributeField.isAnnotationPresent(XmlElement.class)) {
            attributeName = attributeField.getAnnotation(XmlElement.class).name();
        }
        if (attributeField.isAnnotationPresent(XmlElementRef.class)) {
            attributeName = attributeField.getAnnotation(XmlElementRef.class).name();
        }
        if (JAXB_ATTRIBUTE_NAME_DEFAULT.equals(attributeName)) {
            attributeName = attributeField.getName();
        }
        return attributeName;
    }

    private void populateFields() {
        try {
            for (Field field : JaxbReflectionInfo.findAllFieldsIncludingInherited(this.modelObjectClass)) {
                field.setAccessible(true);
                String nameOrOverridenName = JaxbReflectionInfo.getOverridenNameOrName(field);
                if (JaxbReflectionInfo.isComplexChildField(field)) {
                    this.childrenFieldInfos.put(nameOrOverridenName, new JaxbReflectionFieldInfo(field, JaxbReflectionFieldInfo.Type.CHILD, nameOrOverridenName));
                    continue;
                }
                if (JaxbReflectionInfo.isAttributeField(field)) {
                    this.attributeFieldInfos.put(nameOrOverridenName, new JaxbReflectionFieldInfo(field, JaxbReflectionFieldInfo.Type.ATTRIBUTE, nameOrOverridenName));
                    continue;
                }
                assert (false) : String.format("Unrecognized JAXB field '%s' in class '%s'.", field.getName(), this.modelObjectClass.getSimpleName());
            }
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException("Illegal argument.", (Throwable)e);
        }
    }

    private static List<Field> findAllFieldsIncludingInherited(Class<? extends ModelObject> modelObjectClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<? extends ModelObject> currentClass = modelObjectClass; currentClass != null && !currentClass.equals(AbstractJaxbModelObject.class); currentClass = currentClass.getSuperclass()) {
            fields.addAll(0, Arrays.asList(currentClass.getDeclaredFields()));
        }
        return fields;
    }

    private static boolean isModelObjectCollectionField(Field field) {
        if (!Collection.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type collectionItemType = field.getGenericType();
        String collectionItemClassName = collectionItemType.toString();
        collectionItemClassName = collectionItemClassName.substring(collectionItemClassName.indexOf(60) + 1, collectionItemClassName.indexOf(62));
        try {
            Class<?> collectionItemClass = Class.forName(collectionItemClassName);
            return ModelObject.class.isAssignableFrom(collectionItemClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

