package com.ebmwebsourcing.easybox.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;

import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlElement;

import com.ebmwebsourcing.easycommons.reflect.ReflectionHelper;

final class JaxbReflectionFieldInfo {

	static enum Type { CHILD, ATTRIBUTE }

	private final Field field;
	private final Type type;
	private final String name;
	private final Method getterMethod;
	private final Method setterMethod;

	public JaxbReflectionFieldInfo(Field field, Type type, String name) {
		this.field = field;
		this.type = type;
		this.name = name;
		this.getterMethod = guessGetterMethod(field);
		this.setterMethod = guessSetterMethod(field);
	}

	private static Method guessGetterMethod(Field field) {
		String prefix = "get";
		if (Boolean.class.equals(field.getType()) || boolean.class.equals(field.getType())) {
			prefix = "is";
		}
		return guessPrefixedMethod(field, prefix);
	}


	private static Method guessSetterMethod(Field field) {
		if (Collection.class.isAssignableFrom(field.getType())) return null;
		if (field.isAnnotationPresent(XmlAnyAttribute.class)) return null;
		Class<?> fieldType = field.getType();
		if (fieldType == Boolean.class) fieldType = boolean.class;
		if (fieldType == Byte.class) fieldType = byte.class;
		if (fieldType == Short.class) fieldType = short.class;
		if (fieldType == Integer.class) fieldType = int.class;
		if (fieldType == Long.class) fieldType = long.class;
		if (fieldType == Double.class) fieldType = double.class;
		if (fieldType == Float.class) fieldType = float.class;
		return guessPrefixedMethod(field, "set", fieldType);
	}
	
	
	private static Method guessPrefixedMethod(Field field, String prefix, Class<?>... parameterTypes) {
		assert field != null;

		XmlElement elmtAnnotation = field.getAnnotation(XmlElement.class);
		String fieldName = null;
		if(elmtAnnotation != null && elmtAnnotation.name() != null 
				&& !elmtAnnotation.name().equals(JaxbReflectionInfo.JAXB_ATTRIBUTE_NAME_DEFAULT)
				&& !elmtAnnotation.name().contains("-")) {
			fieldName = elmtAnnotation.name();
		} else {
			fieldName = field.getName().replaceAll("^_*", "");
		}
		if (fieldName.length() == 1) {
			return ReflectionHelper.getPublicMethod(field.getDeclaringClass(), 
					prefix + fieldName.substring(0, 1).toUpperCase(), parameterTypes);
		} else {
			return ReflectionHelper.getPublicMethod(field.getDeclaringClass(), prefix + 
					fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), 
					parameterTypes);
		}    
	}


	public Field getField() {
		return field;
	}

	public Type getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public Method getGetterMethod() {
		return getterMethod;
	}

	public Method getSetterMethod() {
		return setterMethod;
	}


}
