package com.ebmwebsourcing.easybox.impl;

import javax.xml.bind.JAXBElement;

import org.w3c.dom.Element;
import org.w3c.dom.Text;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

final class ModelObjectFactory {

    private static final String MODEL_OBJECT_USERDATA_KEY = "modelObject"; 
    
    
    static ModelObject createModelObject(ModelObject parent, Object obj) {
    	assert obj != null;
        if (obj instanceof ModelObject) {
            return (ModelObject) obj;
        } else if (obj instanceof JAXBElement<?>) {
        	JAXBElement<?> jaxbElement = (JAXBElement<?>) obj;
        	if (jaxbElement.getValue() == null) return null;
            return createModelObject(parent, jaxbElement.getValue());
        } else if (obj instanceof Text) {
            Text textNode = (Text) obj;
            // TODO : not sure this takes the right parent
            ModelObject parentModelObject = ModelObjectFactory.createModelObject(null, textNode.getParentNode());
            return ModelObjectFactory.createModelObject(parentModelObject, textNode.getNodeValue());
        } else if (obj instanceof String) {
            String s = (String) obj;
            if (s.trim().isEmpty()) {
                // do not take into account empty text nodes.
                return null;
            } else {
                return new TextModelObject(parent, s);
            }
        } else if (obj instanceof Element) {
            Element element = (Element) obj;
            Object userData = element.getUserData(MODEL_OBJECT_USERDATA_KEY);
            if (userData != null) {
                return (ModelObject) userData;
            }
            ModelObject modelObject =  new DomModelObject(parent, (Element) obj);
            element.setUserData(MODEL_OBJECT_USERDATA_KEY, modelObject, null);
            return modelObject;
        } else {
            throw new UncheckedException(String.format("Cannot create model object for obj of type '%s'.", obj.getClass()));
        }
    }
    
    
}
