/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.impl.AbstractModelObject;
import com.ebmwebsourcing.easycommons.lang.ArrayHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractXmlObjectNodeImpl<Model extends ModelObject>
implements XmlObjectNode {
    private final XmlContext xmlContext;
    private Model modelObject;
    private Object userData;
    private int xmlObjectIndex;
    private Integer[] xmlObjectBaseIndexes;

    protected AbstractXmlObjectNodeImpl(XmlContext xmlContext, Model modelObject) {
        assert (xmlContext != null);
        this.xmlContext = xmlContext;
        this.userData = null;
        this.xmlObjectIndex = -1;
        this.xmlObjectBaseIndexes = null;
        this.setModelObject(modelObject);
    }

    public final XmlContext getXmlContext() {
        return this.xmlContext;
    }

    public Model getModelObject() {
        return this.modelObject;
    }

    protected final void setModelObject(Model modelObject) {
        if (modelObject == null) {
            modelObject = this.createCompliantModel();
        }
        this.modelObject = modelObject;
        if (this.getModelObject() != null) {
            ((AbstractModelObject)this.getModelObject()).setXmlObject(this);
        }
    }

    protected abstract Model createCompliantModel();

    public final int hashCode() {
        return super.hashCode();
    }

    public abstract boolean equals(Object var1);

    private void getXmlObjectBaseIndexes(List<Integer> indexes) {
        AbstractXmlObjectNodeImpl parent = (AbstractXmlObjectNodeImpl)this.getXmlObjectParent();
        if (parent == null || parent.getXmlObjectBaseURI() != this.getXmlObjectBaseURI()) {
            indexes.add(0);
        } else {
            parent.getXmlObjectBaseIndexes(indexes);
            indexes.add(this.getXmlObjectIndex());
        }
    }

    public Integer[] getXmlObjectBaseIndexes() {
        if (this.xmlObjectBaseIndexes == null) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            this.getXmlObjectBaseIndexes(indexes);
            this.xmlObjectBaseIndexes = indexes.toArray(new Integer[indexes.size()]);
        }
        return this.xmlObjectBaseIndexes;
    }

    public final String getXmlObjectBaseXPath() {
        StringBuffer sb = new StringBuffer();
        Integer[] arr$ = this.getXmlObjectBaseIndexes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            sb.append("/*[").append(i + 1).append("]");
        }
        return sb.toString();
    }

    public final XmlObject getXmlObjectBaseRoot() {
        AbstractXmlObjectNodeImpl current = this;
        XmlObject parent;
        while ((parent = current.getXmlObjectParent()) != null) {
            URI currentURI = this.getXmlObjectBaseURI();
            if (currentURI != null && !currentURI.equals(parent.getXmlObjectBaseURI())) {
                return (XmlObject)current;
            }
            current = parent;
        }
        return (XmlObject)current;
    }

    public final int getXmlObjectIndex() {
        if (this.xmlObjectIndex == -1) {
            this.xmlObjectIndex = this.guessIndexFromParent(this.getXmlObjectParent());
        }
        return this.xmlObjectIndex;
    }

    public final XmlObjectNode getXmlObjectFollowingSibling() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return null;
        }
        XmlObjectNode[] children = parent.getXmlObjectChildren();
        boolean found = false;
        for (XmlObjectNode child : children) {
            if (found) {
                return child;
            }
            if (child != this) continue;
            found = true;
        }
        return null;
    }

    public final XmlObjectNode getXmlObjectPrecedingSibling() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return null;
        }
        XmlObjectNode[] children = parent.getXmlObjectChildren();
        XmlObjectNode previous = null;
        for (XmlObjectNode child : children) {
            if (child == this) {
                return previous;
            }
            previous = child;
        }
        return null;
    }

    public final XmlObject[] getXmlObjectAncestors() {
        LinkedList<XmlObject> ancestors = new LinkedList<XmlObject>();
        AbstractXmlObjectNodeImpl current = this;
        XmlObject parent = null;
        while ((parent = current.getXmlObjectParent()) != null) {
            ancestors.addFirst(parent);
            current = parent;
        }
        return ancestors.toArray(new XmlObject[ancestors.size()]);
    }

    private void appendXmlObjectDescendants(XmlObjectNode xo, List<XmlObjectNode> result, IdentityHashMap<XmlObjectNode, Object> descendantsMap) {
        XmlObjectNode[] children;
        for (XmlObjectNode child : children = xo.getXmlObjectChildren()) {
            if (descendantsMap.containsKey(child)) continue;
            descendantsMap.put(child, null);
            result.add(child);
            this.appendXmlObjectDescendants(child, result, descendantsMap);
        }
    }

    public final XmlObjectNode[] getXmlObjectDescendants() {
        LinkedList<XmlObjectNode> descendants = new LinkedList<XmlObjectNode>();
        this.appendXmlObjectDescendants(this, descendants, new IdentityHashMap<XmlObjectNode, Object>());
        return descendants.toArray(new XmlObjectNode[descendants.size()]);
    }

    public final XmlObject getXmlObjectParent() {
        if (this.getModelObject() == null) {
            return null;
        }
        if (this.getModelObject().getParent() == null) {
            return null;
        }
        return (XmlObject)this.getXmlContext().getXmlObjectFactory().wrap((Object)this.getModelObject().getParent());
    }

    public final XmlObjectNode[] getXmlObjectFollowing() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return EMPTY_ARRAY;
        }
        XmlObjectNode[] descendants = this.getXmlObjectDescendants();
        AbstractXmlObjectNodeImpl lastXmlObjectBeforeFollowing = this;
        if (descendants.length != 0) {
            lastXmlObjectBeforeFollowing = descendants[descendants.length - 1];
        }
        XmlObjectNode[] rootDescendants = this.getXmlObjectRoot().getXmlObjectDescendants();
        LinkedList<XmlObjectNode> following = new LinkedList<XmlObjectNode>();
        boolean lastXmlObjectBeforeFollowingFound = false;
        for (XmlObjectNode descendantXmlObject : rootDescendants) {
            if (descendantXmlObject == lastXmlObjectBeforeFollowing) {
                lastXmlObjectBeforeFollowingFound = true;
                continue;
            }
            if (!lastXmlObjectBeforeFollowingFound) continue;
            following.add(descendantXmlObject);
        }
        return following.toArray(new XmlObjectNode[following.size()]);
    }

    public final XmlObjectNode[] getXmlObjectFollowingSiblings() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return EMPTY_ARRAY;
        }
        XmlObjectNode[] children = parent.getXmlObjectChildren();
        boolean found = false;
        LinkedList<XmlObjectNode> followingSiblings = new LinkedList<XmlObjectNode>();
        for (XmlObjectNode child : children) {
            if (found) {
                followingSiblings.add(child);
            }
            if (child != this) continue;
            found = true;
        }
        return followingSiblings.toArray(new XmlObjectNode[followingSiblings.size()]);
    }

    public final XmlObjectNode[] getXmlObjectPrecedingSiblings() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return EMPTY_ARRAY;
        }
        XmlObjectNode[] children = parent.getXmlObjectChildren();
        LinkedList<XmlObjectNode> precedingSiblings = new LinkedList<XmlObjectNode>();
        for (XmlObjectNode child : children) {
            if (child == this) break;
            precedingSiblings.add(child);
        }
        return precedingSiblings.toArray(new XmlObjectNode[precedingSiblings.size()]);
    }

    public final XmlObjectNode[] getXmlObjectPreceding() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return EMPTY_ARRAY;
        }
        AbstractXmlObjectNodeImpl lastXmlObjectAfterPreceding = this;
        XmlObjectNode[] rootDescendants = this.getXmlObjectRoot().getXmlObjectDescendants();
        LinkedList<XmlObjectNode> preceding = new LinkedList<XmlObjectNode>();
        Object[] ancestors = this.getXmlObjectAncestors();
        for (XmlObjectNode descendantXmlObject : rootDescendants) {
            if (descendantXmlObject == lastXmlObjectAfterPreceding) break;
            if (ArrayHelper.arrayContainsSameObject((Object[])ancestors, (Object)descendantXmlObject)) continue;
            preceding.add(descendantXmlObject);
        }
        return preceding.toArray(new XmlObjectNode[preceding.size()]);
    }

    public final XmlObjectNode[] getXmlObjectPrecedingOrAncestor() {
        XmlObject parent = this.getXmlObjectParent();
        if (parent == null) {
            return EMPTY_ARRAY;
        }
        AbstractXmlObjectNodeImpl lastXmlObjectAfterPreceding = this;
        XmlObject root = this.getXmlObjectRoot();
        XmlObjectNode[] rootDescendants = root.getXmlObjectDescendants();
        LinkedList<Object> precedingOrAncestor = new LinkedList<Object>();
        precedingOrAncestor.add(root);
        for (XmlObjectNode descendantXmlObject : rootDescendants) {
            if (descendantXmlObject == lastXmlObjectAfterPreceding) break;
            precedingOrAncestor.add(descendantXmlObject);
        }
        return precedingOrAncestor.toArray(new XmlObjectNode[precedingOrAncestor.size()]);
    }

    public final XmlObject getXmlObjectRoot() {
        AbstractXmlObjectNodeImpl current = this;
        XmlObject parent;
        while ((parent = current.getXmlObjectParent()) != null) {
            current = parent;
        }
        return (XmlObject)current;
    }

    public final int compareTo(XmlObjectNode other) {
        Integer[] indexes = this.getXmlObjectBaseIndexes();
        Integer[] otherIndexes = other.getXmlObjectBaseIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            if (otherIndexes.length == i) {
                return 1;
            }
            int otherIndex = otherIndexes[i];
            if (otherIndex < index) {
                return 1;
            }
            if (index >= otherIndex) continue;
            return -1;
        }
        if (otherIndexes.length > indexes.length) {
            return -1;
        }
        return 0;
    }

    public abstract String toString();

    private final int guessIndexFromParent(XmlObject newParent) {
        if (newParent == null) {
            return 0;
        }
        XmlObjectNode[] children = newParent.getXmlObjectNaturalChildren();
        int i = 0;
        for (XmlObjectNode child : children) {
            if (child == this) {
                return i;
            }
            ++i;
        }
        children = newParent.getXmlObjectAdoptedChildren();
        i = 0;
        for (XmlObjectNode child : children) {
            if (child == this) {
                return i;
            }
            ++i;
        }
        throw new UncheckedException("XML object has a parent but no index!");
    }

    final void setAdoptiveParent(XmlObject parent, int adoptionIndex) {
        this.xmlObjectIndex = parent.getXmlObjectNaturalChildren().length + adoptionIndex;
        this.onAdoptiveParentChange(parent);
    }

    final void setNaturalParent(XmlObject parent) {
        this.xmlObjectIndex = -1;
        this.onNaturalParentChange(parent);
        this.onBaseHierarchyChange();
    }

    protected void onNaturalParentChange(XmlObject parent) {
    }

    protected void onAdoptiveParentChange(XmlObject parent) {
    }

    protected final void onBaseHierarchyChange() {
        for (XmlObjectNode xon : this.getXmlObjectNaturalChildren()) {
            AbstractXmlObjectNodeImpl axon = (AbstractXmlObjectNodeImpl)xon;
            axon.onBaseHierarchyChange();
        }
    }

    public XmlObjectNode[] getXmlObjectChildren() {
        XmlObjectNode[] naturalChildren = this.getXmlObjectNaturalChildren();
        XmlObjectNode[] adoptedChildren = this.getXmlObjectAdoptedChildren();
        if (adoptedChildren.length == 0) {
            return naturalChildren;
        }
        return (XmlObjectNode[])ArrayHelper.mergeArrays((Object[][])new XmlObjectNode[][]{adoptedChildren, naturalChildren});
    }

    public XmlObjectNode[] getXmlObjectNaturalChildren() {
        return XmlObjectNode.EMPTY_ARRAY;
    }

    public XmlObjectNode[] getXmlObjectAdoptedChildren() {
        return XmlObjectNode.EMPTY_ARRAY;
    }

    public String getXmlObjectTextContent() {
        XmlObjectNode[] descendants = this.getXmlObjectDescendants();
        StringBuffer sb = new StringBuffer();
        for (XmlObjectNode xon : descendants) {
            Object value = xon.getXmlObjectValue();
            sb.append(value == null ? "" : String.valueOf(value));
        }
        return sb.toString();
    }

    public final boolean hasUserData() {
        return this.userData != null;
    }

    public Object getUserData() {
        assert (this.userData != null);
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

