
package com.ebmwebsourcing.easybox.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathExpressionException;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.easybox.api.Catalog;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;

final class XmlObjectAdoptionMediator {

    private final Map<String, XmlObject> adoptedChildrenCache;

    private XmlContextImpl xmlContext;

    XmlObjectAdoptionMediator(XmlObject xmlObject) {
        this.adoptedChildrenCache = new HashMap<String, XmlObject>();
        URI baseURI = xmlObject.getXmlObjectBaseURI();
        if (baseURI != null) {
            adoptedChildrenCache.put(makeAdoptedChildKey(baseURI, ""),
                    xmlObject.getXmlObjectBaseRoot());
        }
        this.xmlContext = (XmlContextImpl) xmlObject.getXmlContext();
    }

    private String makeAdoptedChildKey(URI baseURI, String xpath) {
        assert baseURI != null;
        return baseURI.toString() + "#" + xpath;
    }

    private XmlObject resolveXPath(XmlObject contextXmlObject, String xpath) {
        if (xpath.isEmpty())
            return contextXmlObject;
        XmlObjectXPathEvaluator xpe = contextXmlObject.getXmlContext().createXPathEvaluator();
        try {
            XmlObject childToAdopt = xpe.selectSingleXmlObjectNode(contextXmlObject, xpath,
                    XmlObject.class);
            return childToAdopt;
        } catch (XPathExpressionException xpee) {
            throw new UncheckedException(String.format("Invalid XPath expression '%s'.", xpath));
        }
    }

    XmlObject adoptChild(XmlObject parentAdopter, String publicId, String systemId, Object object) {
        assert parentAdopter != null;
        Source s = null;
        URI resolvedUri = null;
        try {
            if (publicId != null) {
                resolvedUri = Catalog.getInstance().resolveUri(publicId);
                if (resolvedUri != null) {
                    s = new SAXSource(new InputSource(resolvedUri.toURL().openStream()));
                }
            }
            if (resolvedUri == null) {
                if (systemId == null) {
                    // in last resort, if systemId is null, and catalog does not
                    // know about public id, try to use public id as system id.
                    systemId = publicId;
                }
                URI baseURI = parentAdopter.getXmlObjectBaseURI();

                URI newUri = URIHelper.resolve(baseURI, systemId);
                if(newUri == null) {
                    if(baseURI !=  null && !baseURI.isAbsolute()) {
                        baseURI = null;
                        newUri = URI.create(systemId);
                    } else {
                        throw new UncheckedException(String.format(
                                "Problem to resolve Uri. Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId,
                                systemId, String.valueOf(parentAdopter.getXmlObjectBaseURI())));
                    }
                }

                resolvedUri = Catalog.getInstance().resolveUri(newUri);
                if (resolvedUri == null) {
                    resolvedUri = newUri;
                }

                assert resolvedUri != null;
                String base = null;
                if(baseURI != null) {
                    base = baseURI.toString();
                }

                s = this.xmlContext.getURIResolver().resolve(resolvedUri.toString(),
                        base);

            }
        } catch (MalformedURLException e) {
            throw new UncheckedException(e.getMessage());
        } catch (URISyntaxException e) {
            throw new UncheckedException(e.getMessage());
        } catch (IOException e) {
            throw new UncheckedException(e.getMessage());
        } catch (TransformerException e) {
            throw new UncheckedException(e.getMessage());
        }
        InputSource is = null;
        if (s != null) {
            is = SourceHelper.sourceToInputSource(s, publicId, resolvedUri.toString());
            return adoptChild(parentAdopter, is, resolvedUri, null);
        } else {
            throw new UncheckedException(String.format(
                    "Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId,
                    systemId, String.valueOf(parentAdopter.getXmlObjectBaseURI())));
        }
    }

    private XmlObject adoptChild(XmlObject adoptiveParent, InputSource s, URI sourceUri,
            String xpath) {
        assert adoptiveParent != null;
        assert sourceUri != null;
        if (xpath == null)
            xpath = "";
        String key = makeAdoptedChildKey(sourceUri, xpath);
        if (adoptedChildrenCache.containsKey(key)) {
            return adoptedChildrenCache.get(key);
        }
        XmlObject childToAdopt;
        URI baseURI = adoptiveParent.getXmlObjectBaseURI();
        
        if (baseURI == null && s == null) {
            throw new UncheckedException(
                    "Cannot adopt child because adoptive parent has no base URI and sourceUri is not absolute: "
                            + sourceUri);
        }
        if (baseURI != null && baseURI.equals(sourceUri)) {
            // internal adoption.
            childToAdopt = resolveXPath(adoptiveParent.getXmlObjectRoot(), xpath);
        } else {
            // external adoption.
            XmlObjectReader reader = adoptiveParent.getXmlContext().createReader();

            // created reader is set in lazy mode, otherwise we might fall in an
            // infinite recursion.
            reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
            try {
                XmlObject readXmlObject = reader.readDocument(s, XmlObject.class);
                childToAdopt = resolveXPath(readXmlObject, xpath);
            } catch (XmlObjectReadException e) {
                throw new UncheckedException(
                        String.format(
                                "Cannot adopt child from URI '%s' and XPath '%s' (XmlObjectReadException).",
                                sourceUri.toString(), xpath), e);
            }

        }
        assert childToAdopt != null;
        adoptedChildrenCache.put(key, childToAdopt);
        return childToAdopt;
    }

}
