package com.ebmwebsourcing.easybox.impl;

import static com.ebmwebsourcing.easybox.impl.NodeInfoHelper.*;

import java.net.URI;

import javax.xml.namespace.QName;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;

abstract class XmlObjectNodeNodeInfo implements NodeInfo {

    // TODO : / should return an XmlObjectDocument ; otherwise we cannot start expressions by //!
    
    private final XmlObjectNode xmlObjectNode;
    private final Configuration configuration;

    public XmlObjectNodeNodeInfo(XmlObjectNode xmlObjectNode, Configuration configuration) {
        this.xmlObjectNode = xmlObjectNode;
        this.configuration = configuration;
    }

    XmlObjectNode getXmlObjectNode() {
        return xmlObjectNode;
    }

    @Override
    public abstract Value atomize() throws XPathException;

    @Override
    public final int compareOrder(NodeInfo other) {
        assert other instanceof XmlObjectNodeNodeInfo;
        return this.getXmlObjectNode().compareTo(((XmlObjectNodeNodeInfo) other).getXmlObjectNode());
    }

    @Override
    public final void copy(Receiver arg0, int arg1, boolean arg2, int arg3) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final void generateId(FastStringBuffer arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getAttributeValue(int arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getBaseURI() {
        URI baseURI = xmlObjectNode.getXmlObjectBaseURI();
        return baseURI == null ? null : baseURI.toString(); 
    }

    @Override
    public final int getColumnNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final Configuration getConfiguration() {
        return configuration;
    }

    @Override
    public final int[] getDeclaredNamespaces(int[] arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getDisplayName() {
        QName qname = xmlObjectNode.getXmlObjectQName();
        if (qname == null) return "";
        StringBuffer lexicalQName = new StringBuffer();
        if (qname.getPrefix() != null) {
            lexicalQName.append(qname.getPrefix()).append(":");
        }
        lexicalQName.append(qname.getLocalPart());
        return lexicalQName.toString();
    }

    @Override
    public final long getDocumentNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final DocumentInfo getDocumentRoot() {
        // TODO : 2 modes adoption mode, natural mode. 
        XmlObject xmlObjectBaseRoot = xmlObjectNode.getXmlObjectBaseRoot(); 
        return new XmlObjectDocumentInfo(xmlObjectBaseRoot, configuration);
    }

    @Override
    public final int getFingerprint() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final int getLineNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getLocalPart() {
        return xmlObjectNode.getXmlObjectQName().getLocalPart();
    }

    @Override
    public final int getNameCode() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final NamePool getNamePool() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final NodeInfo getParent() {
    	XmlObject parent = xmlObjectNode.getXmlObjectParent();
    	if (parent == null) return null;
    	return new XmlObjectNodeInfo(parent, configuration);
    }

    @Override
    public final String getPrefix() {
        return xmlObjectNode.getXmlObjectQName().getPrefix();
    }

    @Override
    public final NodeInfo getRoot() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getStringValue() {
        return getXmlObjectNode().getXmlObjectTextContent();
    }

    @Override
    public final String getSystemId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final int getTypeAnnotation() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getURI() {
        return xmlObjectNode.getXmlObjectQName().getNamespaceURI();
    }

    @Override
    public final boolean isId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isIdref() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isNilled() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isSameNodeInfo(NodeInfo other) {
        assert other instanceof XmlObjectNodeNodeInfo;
        return ((XmlObjectNodeNodeInfo) other).getXmlObjectNode() == getXmlObjectNode();
    }

    @Override
    public final AxisIterator iterateAxis(byte arg0) {
        return iterateAxis(arg0, null);
    }


    @Override
    public final AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return createAxisIterator(axisNumber, xmlObjectNode, nodeTest, configuration);
    }

    @Override
    public final void setSystemId(String systemId) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final CharSequence getStringValueCS() {
        return getStringValue();
    }

    @Override
    public abstract SequenceIterator getTypedValue() throws XPathException;

    @Override
    public final String toString() {
        return xmlObjectNode.toString(); 
    }
    
}
