/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObjectXPathBasedFinder;
import com.ebmwebsourcing.easybox.api.TestRuntimeException;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbFinder;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.ModelObjectFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

public class JaxbXPathBasedFinder
extends AbstractJaxbFinder
implements ModelObjectXPathBasedFinder {
    public final XPath xpath;

    public JaxbXPathBasedFinder() {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.xpath = xpathFactory.newXPath();
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.xpath.setNamespaceContext(namespaceContext);
    }

    @Override
    public final Object find(String testResourcePath, String searchCriterion) {
        AbstractJaxbModelObject rootJaxbObject = this.unmarshallAsModelObject(testResourcePath);
        try {
            Node domNode = (Node)this.xpath.evaluate(searchCriterion, rootJaxbObject.getBinder().getXMLNode((Object)rootJaxbObject), XPathConstants.NODE);
            assert (domNode != null) : String.format("Could not find DOM node matching XPath expression '%s'", searchCriterion);
            Object foundObject = rootJaxbObject.getBinder().getJAXBNode((Object)domNode);
            if (foundObject == null) {
                foundObject = domNode;
            }
            return ModelObjectFactory.createModelObject(null, (Object)foundObject);
        }
        catch (XPathExpressionException e) {
            throw new TestRuntimeException(String.format("Cannot find object with xpath '%s' on resource '%s'", searchCriterion, testResourcePath), (Throwable)e);
        }
    }
}

