package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectText;

final class XmlObjectTextImpl extends AbstractXmlObjectNodeImpl<TextModelObject> implements XmlObjectText {


    XmlObjectTextImpl(XmlContext xmlContext, TextModelObject textModelObject) {
        super(xmlContext, textModelObject);
    }

    @Override
    public String getXmlObjectTextContent() {
        return getXmlObjectValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XmlObjectTextImpl other = (XmlObjectTextImpl) obj;
        if (getXmlObjectValue() == null) {
            if (other.getXmlObjectValue() != null)
                return false;
        } else if (!getXmlObjectValue().equals(other.getXmlObjectValue()))
            return false;
        return true;
    }

    @Override
    public XmlObjectNode[] getXmlObjectChildren() {
        return XmlObjectNode.EMPTY_ARRAY;
    }
    
    @Override
    public String toString() {
        return "\n# '" + getXmlObjectValue() + "'";
    }

    @Override
    public String getXmlObjectValue() {
        return getModelObject().getValue();
    }
    
    @Override
    public QName getXmlObjectQName() {
        return null;
    }
    
    @Override
    public URI getXmlObjectBaseURI() {
        return URI.create(getModelObject().getDOMNode().getBaseURI());
    }
    
    @Override
    protected TextModelObject createCompliantModel() {
        return new TextModelObject(null, "");
    }
    
    @Override
    public void setText(String text){
        getModelObject().setValue(text);
    }
    
}
