package com.ebmwebsourcing.easybox.impl;

import javax.xml.namespace.QName;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

import com.ebmwebsourcing.easybox.api.XmlObjectAttribute;

final class XmlObjectAttributeNodeInfo extends XmlObjectNodeNodeInfo {


    public XmlObjectAttributeNodeInfo(XmlObjectAttribute xmlObjectAttribute, Configuration configuration) {
        super(xmlObjectAttribute, configuration);
    }


    @Override
    public final Value atomize() throws XPathException {
        Object value = getXmlObjectNode().getXmlObjectValue();
        if (value instanceof QName) {
            QName qname = (QName) value;
            return new QNameValue(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart()); 
        } else {
            // TODO implement other types!!!
            return new StringValue(String.valueOf(value));
        }
    }
    
    
    @Override
    XmlObjectAttribute getXmlObjectNode() {
        return (XmlObjectAttribute) super.getXmlObjectNode();
    }

    @Override
    public int getNodeKind() {
        return Type.ATTRIBUTE;
    }
    
    @Override
    public boolean hasChildNodes() {
        return false;
    }
    
    @Override
    public final SequenceIterator getTypedValue() throws XPathException {
        return atomize().iterate();
    }

}
