/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlElement;

final class JaxbReflectionFieldInfo {
    private final Field field;
    private final Type type;
    private final String name;
    private final Method getterMethod;
    private final Method setterMethod;

    public JaxbReflectionFieldInfo(Field field, Type type, String name) {
        this.field = field;
        this.type = type;
        this.name = name;
        this.getterMethod = JaxbReflectionFieldInfo.guessGetterMethod(field);
        this.setterMethod = JaxbReflectionFieldInfo.guessSetterMethod(field);
    }

    private static Method guessGetterMethod(Field field) {
        String prefix = "get";
        if (Boolean.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType())) {
            prefix = "is";
        }
        return JaxbReflectionFieldInfo.guessPrefixedMethod(field, prefix, new Class[0]);
    }

    private static Method guessSetterMethod(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            return null;
        }
        if (field.isAnnotationPresent(XmlAnyAttribute.class)) {
            return null;
        }
        Class<Object> fieldType = field.getType();
        if (fieldType == Boolean.class) {
            fieldType = Boolean.TYPE;
        }
        if (fieldType == Byte.class) {
            fieldType = Byte.TYPE;
        }
        if (fieldType == Short.class) {
            fieldType = Short.TYPE;
        }
        if (fieldType == Integer.class) {
            fieldType = Integer.TYPE;
        }
        if (fieldType == Long.class) {
            fieldType = Long.TYPE;
        }
        if (fieldType == Double.class) {
            fieldType = Double.TYPE;
        }
        if (fieldType == Float.class) {
            fieldType = Float.TYPE;
        }
        return JaxbReflectionFieldInfo.guessPrefixedMethod(field, "set", fieldType);
    }

    private static Method guessPrefixedMethod(Field field, String prefix, Class<?> ... parameterTypes) {
        assert (field != null);
        XmlElement elmtAnnotation = field.getAnnotation(XmlElement.class);
        String fieldName = null;
        fieldName = elmtAnnotation != null && elmtAnnotation.name() != null && !elmtAnnotation.name().equals("##default") && !elmtAnnotation.name().contains("-") ? elmtAnnotation.name() : field.getName().replaceAll("^_*", "");
        if (fieldName.length() == 1) {
            return ReflectionHelper.getPublicMethod(field.getDeclaringClass(), (String)(prefix + fieldName.substring(0, 1).toUpperCase()), (Class[])parameterTypes);
        }
        return ReflectionHelper.getPublicMethod(field.getDeclaringClass(), (String)(prefix + JaxbReflectionFieldInfo.toCamelCase(fieldName)), (Class[])parameterTypes);
    }

    public Field getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    static String toCamelCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        for (String part : parts) {
            camelCaseString = camelCaseString + JaxbReflectionFieldInfo.toProperCase(part);
        }
        return camelCaseString;
    }

    static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static enum Type {
        CHILD,
        ATTRIBUTE;

    }
}

