/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.Catalog;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybox.impl.XmlContextImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.InputSource;

final class XmlObjectAdoptionMediator {
    private final Map<String, XmlObject> adoptedChildrenCache = new HashMap<String, XmlObject>();
    private XmlContextImpl xmlContext;

    XmlObjectAdoptionMediator(XmlObject xmlObject) {
        URI baseURI = xmlObject.getXmlObjectBaseURI();
        if (baseURI != null) {
            this.adoptedChildrenCache.put(this.makeAdoptedChildKey(baseURI, ""), xmlObject.getXmlObjectBaseRoot());
        }
        this.xmlContext = (XmlContextImpl)xmlObject.getXmlContext();
    }

    private String makeAdoptedChildKey(URI baseURI, String xpath) {
        assert (baseURI != null);
        return baseURI.toString() + "#" + xpath;
    }

    private XmlObject resolveXPath(XmlObject contextXmlObject, String xpath) {
        if (xpath.isEmpty()) {
            return contextXmlObject;
        }
        XmlObjectXPathEvaluator xpe = contextXmlObject.getXmlContext().createXPathEvaluator();
        try {
            XmlObject childToAdopt = (XmlObject)xpe.selectSingleXmlObjectNode(contextXmlObject, xpath, XmlObject.class);
            return childToAdopt;
        }
        catch (XPathExpressionException xpee) {
            throw new UncheckedException(String.format("Invalid XPath expression '%s'.", xpath));
        }
    }

    XmlObject adoptChild(XmlObject parentAdopter, String publicId, String systemId, Object object) {
        assert (parentAdopter != null);
        Source s = null;
        URI resolvedUri = null;
        try {
            if (publicId != null && (resolvedUri = Catalog.getInstance().resolveUri(publicId)) != null) {
                s = new SAXSource(new InputSource(resolvedUri.toURL().openStream()));
            }
            if (resolvedUri == null) {
                URI baseURI;
                URI newUri;
                if (systemId == null) {
                    systemId = publicId;
                }
                if ((newUri = URIHelper.resolve((URI)(baseURI = parentAdopter.getXmlObjectBaseURI()), (String)systemId)) == null) {
                    if (baseURI != null && !baseURI.isAbsolute()) {
                        baseURI = null;
                        newUri = URI.create(systemId);
                    } else {
                        throw new UncheckedException(String.format("Problem to resolve Uri. Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId, systemId, String.valueOf(parentAdopter.getXmlObjectBaseURI())));
                    }
                }
                if ((resolvedUri = Catalog.getInstance().resolveUri(newUri)) == null) {
                    resolvedUri = newUri;
                }
                assert (resolvedUri != null);
                String base = null;
                if (baseURI != null) {
                    base = baseURI.toString();
                }
                s = this.xmlContext.getURIResolver().resolve(resolvedUri.toString(), base);
            }
        }
        catch (MalformedURLException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (IOException e) {
            throw new UncheckedException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new UncheckedException(e.getMessage());
        }
        InputSource is = null;
        if (s != null) {
            is = SourceHelper.sourceToInputSource(s, (String)publicId, (String)resolvedUri.toString());
            return this.adoptChild(parentAdopter, is, resolvedUri, null);
        }
        throw new UncheckedException(String.format("Cannot adopt child with publicId='%s' systemId='%s' baseURI='%s'", publicId, systemId, String.valueOf(parentAdopter.getXmlObjectBaseURI())));
    }

    private XmlObject adoptChild(XmlObject adoptiveParent, InputSource s, URI sourceUri, String xpath) {
        XmlObject childToAdopt;
        String key;
        assert (adoptiveParent != null);
        assert (sourceUri != null);
        if (xpath == null) {
            xpath = "";
        }
        if (this.adoptedChildrenCache.containsKey(key = this.makeAdoptedChildKey(sourceUri, xpath))) {
            return this.adoptedChildrenCache.get(key);
        }
        URI baseURI = adoptiveParent.getXmlObjectBaseURI();
        if (baseURI == null && s == null) {
            throw new UncheckedException("Cannot adopt child because adoptive parent has no base URI and sourceUri is not absolute: " + sourceUri);
        }
        if (baseURI != null && baseURI.equals(sourceUri)) {
            childToAdopt = this.resolveXPath(adoptiveParent.getXmlObjectRoot(), xpath);
        } else {
            XmlObjectReader reader = adoptiveParent.getXmlContext().createReader();
            reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
            try {
                XmlObject readXmlObject = reader.readDocument(s, XmlObject.class);
                childToAdopt = this.resolveXPath(readXmlObject, xpath);
            }
            catch (XmlObjectReadException e) {
                throw new UncheckedException(String.format("Cannot adopt child from URI '%s' and XPath '%s' (XmlObjectReadException).", sourceUri.toString(), xpath), (Throwable)e);
            }
        }
        assert (childToAdopt != null);
        this.adoptedChildrenCache.put(key, childToAdopt);
        return childToAdopt;
    }
}

