/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybox.impl.AbstractModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybox.impl.JaxbNamespacePrefixMapperImpl;
import com.ebmwebsourcing.easybox.impl.XmlContextImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.OutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class XmlObjectWriterImpl
implements XmlObjectWriter {
    private XmlContextImpl xmlContext;

    public XmlObjectWriterImpl(XmlContextImpl context) {
        this.xmlContext = context;
    }

    private Marshaller newMarshaller() {
        try {
            Marshaller marshaller = this.xmlContext.getJaxbContext().createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new JaxbNamespacePrefixMapperImpl(this.xmlContext));
            }
            catch (PropertyException e) {
                throw new UncheckedException("Unrecognized JAXB property.", (Throwable)e);
            }
            return marshaller;
        }
        catch (JAXBException je) {
            throw new UncheckedException("Cannot create JAXB marshaller.", (Throwable)je);
        }
    }

    public void writeDocument(XmlObject xmlObject, ContentHandler contentHandler) throws XmlObjectWriteException {
        assert (xmlObject instanceof AbstractXmlObjectImpl);
        assert (xmlObject.getXmlObjectQName() != null);
        AbstractModelObject ajo = (AbstractModelObject)((AbstractXmlObjectImpl)xmlObject).getModelObject();
        try {
            this.newMarshaller().marshal((Object)new JAXBElement(xmlObject.getXmlObjectQName(), ajo.getClass(), (Object)ajo), contentHandler);
        }
        catch (JAXBException je) {
            throw new XmlObjectWriteException((Throwable)je);
        }
    }

    public void writeDocument(XmlObject xmlObject, OutputStream outputStream) throws XmlObjectWriteException {
        assert (xmlObject instanceof AbstractXmlObjectImpl);
        try {
            TransformerHandler serializer = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            serializer.setResult(new StreamResult(outputStream));
            this.writeDocument(xmlObject, serializer);
        }
        catch (TransformerConfigurationException e) {
            throw new UncheckedException("Cannot create transformer (TransformerConfigurationException)");
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException("Cannot create transformer (TransformerFactoryConfigurationError)");
        }
    }

    public void writeDocument(XmlObject xmlObject, Node node) throws XmlObjectWriteException {
        assert (xmlObject instanceof AbstractXmlObjectImpl);
        try {
            TransformerHandler serializer = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            serializer.setResult(new DOMResult(node));
            this.writeDocument(xmlObject, serializer);
        }
        catch (TransformerConfigurationException e) {
            throw new UncheckedException("Cannot create transformer (TransformerConfigurationException)");
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException("Cannot create transformer (TransformerFactoryConfigurationError)");
        }
    }
}

