/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.ModelObject;

final class ModelObjectComparator {

    private ModelObjectComparator() {
    }
    
    private static boolean areJAXBElementEquals(JAXBElement<?> o1,
            JAXBElement<?> o2) {
        assert o1 != null;
        assert o2 != null;
        assert o1.getName() != null;
        assert o2.getName() != null;
        if (!o1.getName().equals(o2.getName()))
            return false;
        assert o1.getValue() != null;
        assert o2.getValue() != null;
        return o1.getValue().equals(o2.getValue());
    }

    private static boolean areJAXBObjectEquals(AbstractJaxbModelObject ajo1,
            AbstractJaxbModelObject ajo2) {
        // TODO : can be heavily optimized!
        Map<QName, Object> attributes1 = JaxbReflector
                .collectJaxbAttributes(ajo1);
        Map<QName, Object> attributes2 = JaxbReflector
                .collectJaxbAttributes(ajo2);
        if (!attributes1.equals(attributes2)) {
            return false;
        }
        ModelObject[] children1 = JaxbReflector.collectJaxbChildren(ajo1);
        ModelObject[] children2 = JaxbReflector.collectJaxbChildren(ajo2);
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            if (!areEquals(children1[i], children2[i])) {
                return false;
            }
        }
        return true;

    }

    // TODO refactor this; no need of jaxb comparator.
    static boolean areEquals(ModelObject o1, ModelObject o2) {
        if (o1 == null)
            return o2 == null;
        if (o2 == null)
            return o1 == null;
        if (!o1.getClass().isAssignableFrom(o2.getClass())
                && !o2.getClass().isAssignableFrom(o1.getClass()))
            return false;
        if (o1 instanceof JAXBElement<?>) {
            return areJAXBElementEquals((JAXBElement<?>) o1,
                    (JAXBElement<?>) o2);
        } else if (o1 instanceof AbstractJaxbModelObject) {
          return areJAXBObjectEquals((AbstractJaxbModelObject) o1,
                  (AbstractJaxbModelObject) o2);
        } else {
            return o1.equals(o2);
        }

    }

    
}
