/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easycommons.xml.DOMHelper;

public final class DomModelObject extends AbstractModelObject {

    private ModelObject parentModelObject;
	private final Node domElement;


	public DomModelObject(ModelObject parentModelObject, Node domElement) {
	    this.parentModelObject = parentModelObject;
		this.domElement = domElement;
	}

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((domElement == null) ? 0 : domElement.hashCode());
        return result;
    }


    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DomModelObject other = (DomModelObject) obj;
        if (domElement == null) {
            if (other.domElement != null)
                return false;
        } else if (!DOMHelper.areDOMNodeEqualRegardlessOfNamespaceBindings(
                this.domElement, other.domElement))
            return false;
        return true;
    }


	@Override
	public Node getDOMNode() {
	    return domElement;
	}
	
	
	@Override
	public ModelObject getNaturalParent() {
	    return parentModelObject;
	}

	
	public ModelObject[] getChildren() {
	    // TEMPORARY til we can create dom model objects
	     if (domElement == null) return new ModelObject[0];
        // TEMPORARY til we can create dom model objects
	    
		NodeList nodeList = domElement.getChildNodes();
		List<ModelObject> children = new ArrayList<ModelObject>();
		for (int i = 0 ; i < nodeList.getLength() ; ++i) {
			Node node = nodeList.item(i);
			if (node instanceof Element) {
				children.add(ModelObjectFactory.createModelObject(this, (Element) node));
			}
		}
		return children.toArray(new ModelObject[children.size()]);
	}

	
	@Override
	public URI getBaseURI() {
	    if (parentModelObject == null) return null;
		return parentModelObject.getBaseURI();
	}

	@Override
	public void setBaseURI(URI baseUri) {
	    throw new AssertionError();
	}

	
	@Override
	protected void setNaturalParent(ModelObject modelObject) {
		this.parentModelObject = modelObject;
	}

	@Override
	public ModelObject duplicate() {
	    throw new AssertionError();
	}

	
    @Override
    public <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        throw new AssertionError();
    }
    
    @Override
    public ModelObject getAdoptiveParent() {
        return null;
    }
	
    
    @Override
    protected void setAdoptiveParent(ModelObject modelObject) {
        throw new UnsupportedOperationException();
    }
}
