/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.AbstractActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.SourcesImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.TargetsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivityContainer;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TElseif;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRethrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TThrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;




/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ActivityImpl<E extends TActivity> extends AbstractActivityImpl<E> implements Activity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(ActivityImpl.class.getName());

	private Sources sources = null;

	private Targets targets = null;

	@SuppressWarnings("unchecked")
	public ActivityImpl(final QName name, final E model, final BPELElement parent) {
		super(name, model, parent);
		if(model != null) {
			if(this.model.getSources() != null) {
				this.sources = new SourcesImpl(this.model.getSources(), this);
			}
			if(this.model.getTargets() != null) {
				this.targets = new TargetsImpl(this.model.getTargets(), this);
			}
		}
	}

	public static Activity getActivity(final TActivity internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(internalActivity instanceof TIf) {
			res = new IfImpl((TIf) internalActivity, parent);
		} else if(internalActivity instanceof TEmpty) {
			res = new EmptyImpl((TEmpty) internalActivity, parent);
		} else if(internalActivity instanceof TWait) {
			res = new WaitImpl((TWait) internalActivity, parent);
		} else if(internalActivity instanceof TSequence) {
			res = new SequenceImpl((TSequence) internalActivity, parent);
		} else if(internalActivity instanceof TFlow) {
			res = new FlowImpl((TFlow) internalActivity, parent);
		} else if(internalActivity instanceof TWhile) {
			res = new WhileImpl((TWhile) internalActivity, parent);
		} else if(internalActivity instanceof TForEach) {
			res = new ForEachImpl((TForEach) internalActivity, parent);
		} else if(internalActivity instanceof TRepeatUntil) {
			res = new RepeatUntilImpl((TRepeatUntil) internalActivity, parent);
		} else if(internalActivity instanceof TInvoke) {
			res = new InvokeImpl((TInvoke) internalActivity, parent);
		} else if(internalActivity instanceof TReceive) {
			res = new ReceiveImpl((TReceive) internalActivity, parent);
		} else if(internalActivity instanceof TReply) {
			res = new ReplyImpl((TReply) internalActivity, parent);
		} else if(internalActivity instanceof TAssign) {
			res = new AssignImpl((TAssign) internalActivity, parent);
		} else if(internalActivity instanceof TPick) {
			res = new PickImpl((TPick) internalActivity, parent);
		} else if(internalActivity instanceof TScope) {
			res = new ScopeImpl((TScope) internalActivity, parent);
		} else if(internalActivity instanceof TThrow) {
			res = new ThrowImpl((TThrow) internalActivity, parent);
		} else if(internalActivity instanceof TRethrow) {
			res = new ReThrowImpl((TRethrow) internalActivity, parent);
		} else if (internalActivity instanceof TExit) {
			res =  new ExitImpl((TExit)internalActivity, parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but the activity " + internalActivity.getName() + " is unrecognized or not supported by BPEL engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but the activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	public static void setActivityToOnMessage(Activity activity, OnMessage parent) throws BPELException{

		if(activity instanceof Sequence){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setSequence((TSequence) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Flow ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setFlow((TFlow) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Invoke ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setInvoke((TInvoke) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof Receive ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setReceive((TReceive) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Reply ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setReply((TReply) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Assign ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setAssign((TAssign) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof If ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setIf((TIf) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Pick ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setPick((TPick) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Exit ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setExit((TExit) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Empty ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setEmpty((TEmpty) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof ForEach){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setForEach((TForEach) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof While ){
			((TOnMessage)((BPELElementImpl)parent).getModel()).setWhile((TWhile) ((AbstractSchemaElementImpl)activity).getModel());
		} else{
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}
	
	public static void setActivityToOnAlarm(Activity activity, OnAlarm parent) throws BPELException{
		if(activity instanceof Sequence){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setSequence((TSequence) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof Flow ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setFlow((TFlow) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if( activity instanceof Invoke ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setInvoke((TInvoke) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if (activity instanceof Receive ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setReceive((TReceive) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof Reply ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setReply((TReply) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if( activity instanceof Assign ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setAssign((TAssign) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if( activity instanceof If ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setIf((TIf) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof Pick ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setPick((TPick) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof Exit ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setExit((TExit) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof Empty ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setEmpty((TEmpty) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if (activity instanceof ForEach){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setForEach((TForEach) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else if ( activity instanceof While ){
			((TOnAlarmPick)((BPELElementImpl<?>)parent).getModel()).setWhile((TWhile) ((AbstractSchemaElementImpl<?>)activity).getModel());
		} else{
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}

	public static void setActivityToProcess(Activity activity, BPELProcess parent) throws BPELException{

		if(activity instanceof Sequence){
			((TProcess)((BPELElementImpl)parent).getModel()).setSequence((TSequence) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Flow ){
			((TProcess)((BPELElementImpl)parent).getModel()).setFlow((TFlow) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Invoke ){
			((TProcess)((BPELElementImpl)parent).getModel()).setInvoke((TInvoke) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Receive ){
			((TProcess)((BPELElementImpl)parent).getModel()).setReceive((TReceive) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Reply ){
			((TProcess)((BPELElementImpl)parent).getModel()).setReply((TReply) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Assign ){
			((TProcess)((BPELElementImpl)parent).getModel()).setAssign((TAssign) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof If ){
			((TProcess)((BPELElementImpl)parent).getModel()).setIf((TIf) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Pick ){
			((TProcess)((BPELElementImpl)parent).getModel()).setPick((TPick) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Exit ){
			((TProcess)((BPELElementImpl)parent).getModel()).setExit((TExit) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Empty ){
			((TProcess)((BPELElementImpl)parent).getModel()).setEmpty((TEmpty) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof ForEach){
			((TProcess)((BPELElementImpl)parent).getModel()).setForEach((TForEach) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof While ){
			((TProcess)((BPELElementImpl)parent).getModel()).setWhile((TWhile) ((AbstractSchemaElementImpl)activity).getModel());
		} else {
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}
	
	
	public static void setActivityToIf(Activity activity, If parent) throws BPELException{

		if(activity instanceof Sequence){
			((TIf)((BPELElementImpl)parent).getModel()).setSequence((TSequence) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Flow ){
			((TIf)((BPELElementImpl)parent).getModel()).setFlow((TFlow) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Invoke ){
			((TIf)((BPELElementImpl)parent).getModel()).setInvoke((TInvoke) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Receive ){
			((TIf)((BPELElementImpl)parent).getModel()).setReceive((TReceive) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Reply ){
			((TIf)((BPELElementImpl)parent).getModel()).setReply((TReply) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Assign ){
			((TIf)((BPELElementImpl)parent).getModel()).setAssign((TAssign) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof If ){
			((TIf)((BPELElementImpl)parent).getModel()).setIf((TIf) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Pick ){
			((TIf)((BPELElementImpl)parent).getModel()).setPick((TPick) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Exit ){
			((TIf)((BPELElementImpl)parent).getModel()).setExit((TExit) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Empty ){
			((TIf)((BPELElementImpl)parent).getModel()).setEmpty((TEmpty) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof ForEach){
			((TIf)((BPELElementImpl)parent).getModel()).setForEach((TForEach) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof While ){
			((TIf)((BPELElementImpl)parent).getModel()).setWhile((TWhile) ((AbstractSchemaElementImpl)activity).getModel());
		} else {
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}
	
	
	public static void setActivityToElseIf(Activity activity, TElseif parent) throws BPELException{

		if(activity instanceof Sequence){
			parent.setSequence((TSequence) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Flow ){
			parent.setFlow((TFlow) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Invoke ){
			parent.setInvoke((TInvoke) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Receive ){
			parent.setReceive((TReceive) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Reply ){
			parent.setReply((TReply) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Assign ){
			parent.setAssign((TAssign) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof If ){
			parent.setIf((TIf) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Pick ){
			parent.setPick((TPick) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Exit ){
			parent.setExit((TExit) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Empty ){
			parent.setEmpty((TEmpty) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof ForEach){
			parent.setForEach((TForEach) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof While ){
			parent.setWhile((TWhile) ((AbstractSchemaElementImpl)activity).getModel());
		} else {
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}

	public static void setActivityToActivityContainer(Activity activity, TActivityContainer parent) throws BPELException{
		if(activity instanceof Sequence){
			parent.setSequence((TSequence) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Flow ){
			parent.setFlow((TFlow) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Invoke ){
			parent.setInvoke((TInvoke) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Receive ){
			parent.setReceive((TReceive) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Reply ){
			parent.setReply((TReply) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof Assign ){
			parent.setAssign((TAssign) ((AbstractSchemaElementImpl)activity).getModel());
		} else if( activity instanceof If ){
			parent.setIf((TIf) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Pick ){
			parent.setPick((TPick) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Exit ){
			parent.setExit((TExit) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof Empty ){
			parent.setEmpty((TEmpty) ((AbstractSchemaElementImpl)activity).getModel());
		} else if (activity instanceof ForEach){
			parent.setForEach((TForEach) ((AbstractSchemaElementImpl)activity).getModel());
		} else if ( activity instanceof While ){
			parent.setWhile((TWhile) ((AbstractSchemaElementImpl)activity).getModel());
		} else {
			//TODO : complete activities
			throw new BPELException("setActivity() not yet implemented for "+activity.getClass().getName());
		}
	}

	public static Activity analyzeIfActivity(final TIf internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TIf temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeOnMessageActivity(final TOnMessage internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TOnMessage temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside the onMessage for operation " + temp.getOperation() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside the onMessage for operation " + temp.getOperation() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}
	
	public static Activity analyzeOnAlarmActivity(final TOnAlarmPick internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TOnAlarmPick temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside the onAlarm is either unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside the onAlarm is either unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeWhileActivity(final TWhile internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TWhile temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeRepeatUntilActivity(final TRepeatUntil internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TRepeatUntil temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction]  Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction]  Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeElseIfActivity(final TElseif internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TElseif temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this else activity " + internalActivity + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException( "[BPEL engine restriction] Sorry, but a child activity inside this else activity " + internalActivity + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeActivityContainer(final TActivityContainer internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TActivityContainer temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getClass().getSimpleName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getClass().getSimpleName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeScope(final TScope temp, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(temp.getAssign() != null) {
			res = ActivityImpl.getActivity(temp.getAssign(), parent);
		} else if(temp.getEmpty() != null) {
			res = ActivityImpl.getActivity(temp.getEmpty(), parent);
		} else if(temp.getFlow() != null) {
			res = ActivityImpl.getActivity(temp.getFlow(), parent);
		} else if(temp.getForEach() != null) {
			res = ActivityImpl.getActivity(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getIf() != null) {
			res = ActivityImpl.getActivity(temp.getIf(), parent);
		} else if(temp.getInvoke() != null) {
			res = ActivityImpl.getActivity(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = ActivityImpl.getActivity(temp.getReceive(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getReply() != null) {
			res = ActivityImpl.getActivity(temp.getReply(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getSequence() != null) {
			res = ActivityImpl.getActivity(temp.getSequence(), parent);
		} else if(temp.getWait() != null) {
			res = ActivityImpl.getActivity(temp.getWait(), parent);
		} else if(temp.getWhile() != null) {
			res = ActivityImpl.getActivity(temp.getWhile(), parent);
		} else if(temp.getThrow() != null) {
			res = ActivityImpl.getActivity(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = ActivityImpl.getActivity(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = ActivityImpl.getActivity(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	public static Activity analyzeProcess(final TProcess temp, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(temp.getAssign() != null) {
			res = ActivityImpl.getActivity(temp.getAssign(), parent);
		} else if(temp.getEmpty() != null) {
			res = ActivityImpl.getActivity(temp.getEmpty(), parent);
		} else if(temp.getFlow() != null) {
			res = ActivityImpl.getActivity(temp.getFlow(), parent);
		} else if(temp.getForEach() != null) {
			res = ActivityImpl.getActivity(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getIf() != null) {
			res = ActivityImpl.getActivity(temp.getIf(), parent);
		} else if(temp.getInvoke() != null) {
			res = ActivityImpl.getActivity(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = ActivityImpl.getActivity(temp.getReceive(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getReply() != null) {
			res = ActivityImpl.getActivity(temp.getReply(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getSequence() != null) {
			res = ActivityImpl.getActivity(temp.getSequence(), parent);
		} else if(temp.getWait() != null) {
			res = ActivityImpl.getActivity(temp.getWait(), parent);
		} else if(temp.getWhile() != null) {
			res = ActivityImpl.getActivity(temp.getWhile(), parent);
		} else if(temp.getThrow() != null) {
			res = ActivityImpl.getActivity(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = ActivityImpl.getActivity(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = ActivityImpl.getActivity(temp.getExit(), parent);
		} else {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	@SuppressWarnings("unchecked")
	public static Activity analyzeExtensionActivity(final TExtensionActivity internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TExtensionActivity temp = internalActivity;

		if(temp.getAny() != null) {
			if(temp.getAny() instanceof JAXBElement) {
				final JAXBElement elmt = (JAXBElement)temp.getAny();

			} else if(temp.getAny() instanceof Element) {

			}

			if(res == null){
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(parent, "[BPEL engine restriction] Unknown extensionActivity: " + internalActivity));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(parent, new BPELException("[BPEL engine restriction] Unknown extensionActivity: " + internalActivity)));
			}
		} 
		return res;
	}
}
