/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class FlowImpl extends ActivityImpl<TFlow> implements Flow {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private final List<Activity> activities = new ArrayList<Activity>();


	public FlowImpl(final TFlow model, final BPELElement parent) {
		super(Constants._Flow_QNAME, model, parent);

		for(final Object activity: this.model.getActivity()) {
			try {
				if (activity instanceof TActivity) {
					this.activities.add(ActivityImpl.getActivity((TActivity) activity, this));
				}
			} catch (final BPELException e) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In flow " + this.getName() + " => " + e.getMessage(),e)));
			}
		}
	}

	public List<Activity> getActivities() {
		return this.activities;
	}

	public void addActivity(Activity a) {
		this.activities.add(a);	
		this.model.getActivity().add(((AbstractSchemaElementImpl)a).getModel());
	}



}
