/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ReceiveImpl extends ActivityImpl<TReceive> implements Receive {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(ReceiveImpl.class.getName());

	/**
	 * DO NOT INITIALIZE THIS LIST
	 */
	private List<Correlation> correlations = null;

	//private boolean createInstance; 
	
	@SuppressWarnings("unchecked")
	public ReceiveImpl(final TReceive model, final BPELElement parent) {
		super(Constants._Receive_QNAME, model, parent);
		if(this.model.getCorrelations() != null) {
			this.correlations = new ArrayList<Correlation>();
			for(final TCorrelation corr: this.model.getCorrelations().getCorrelation()) {
				this.correlations.add(new CorrelationImpl(corr, this.model.getCorrelations(), this)); 
			}
			
		}
		log.finest("[DEBUG] CreateInstance is set to  "+String.valueOf(this.model.getCreateInstance())+" in JAXB model...");
		
//		TBoolean tb = model.getCreateInstance();
//		if(tb.compareTo(TBoolean.NO)==0){
//			createInstance = false;
//		}else{
//			createInstance = true;
//		}
	}

	
	public String getInputVariable() {
		return this.model.getVariable();
	}




	public QName getInterface() {
		return this.model.getPortType();
	}




	public String getPartnerLink() {
		return this.model.getPartnerLink();
	}


	public List<Correlation> getCorrelations() {
		return this.correlations;
	}




	public String getMessageExchange() {
		return this.model.getMessageExchange();
	}



	public String getOperation() {
		return this.model.getOperation();
	}


	public boolean getCreateInstance() {
		boolean res = false;
		if((this.model.getCreateInstance() != null) && this.model.getCreateInstance().equals(TBoolean.YES) ) {
			res = true;
		} else {
			res = false;
		}
		return res;
	}


	public void setCreateInstance(boolean b) {
		TBoolean tb;
		if(b){
			tb = TBoolean.YES;
		}else{
			tb = TBoolean.NO;
		}
		this.model.setCreateInstance(tb);
		
	}


	public void setInputVariable(String input) {
		this.model.setVariable(input);
		
	}


	public void setInterface(QName itf) {
		this.model.setPortType(itf);
		
	}


	public void setMessageExchange(String me) {
		this.model.setMessageExchange(me);
	}


	public void setOperation(String operation) {
		
		this.model.setOperation(operation);
		
	}


	public void setPartnerLink(String partner) {
		
		this.model.setPartnerLink(partner);
		
	}

}
